/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.Collection;
import java.util.Iterator;

public class NetworkTool
extends Listener {
    public static final NetworkTool tool = new NetworkTool();
    static boolean debug = false;
    private static NetCell[] cells;
    private static boolean networksValid;
    private static Object mutex;
    static ErrorLogger errorLogger;
    static final int errorSortNetworks = 0;
    static final int errorSortNodes = 1;
    static final int errorSortPorts = 2;
    private static Pref cacheUnifyPowerAndGround;
    private static Pref cacheUnifyLikeNamedNets;
    private static Pref cacheIgnoreResistors;
    private static Pref cacheUnificationPrefix;
    private static Pref cacheBusBaseZero;
    private static Pref cacheBusAscending;

    private NetworkTool() {
        super("network");
        NetworkTool.reload();
    }

    private static void reload() {
        Cell c;
        Iterator cit;
        Library lib;
        int maxCell = 1;
        Iterator lit = Library.getLibraries();
        while (lit.hasNext()) {
            lib = (Library)lit.next();
            cit = lib.getCells();
            while (cit.hasNext()) {
                c = (Cell)cit.next();
                while (c.getCellIndex() >= maxCell) {
                    maxCell *= 2;
                }
            }
        }
        cells = new NetCell[maxCell];
        lit = Library.getLibraries();
        while (lit.hasNext()) {
            lib = (Library)lit.next();
            cit = lib.getCells();
            while (cit.hasNext()) {
                c = (Cell)cit.next();
                if (NetworkTool.getNetCell(c) != null) continue;
                if (c.isIcon() || c.isSchematic()) {
                    new NetSchem(c);
                    continue;
                }
                new NetCell(c);
            }
        }
    }

    static void exportsChanged(Cell cell) {
        NetCell netCell = NetworkTool.getNetCell(cell);
        netCell.exportsChanged();
    }

    static void setCell(Cell cell, NetCell netCell) {
        int cellIndex = cell.getCellIndex();
        if (cellIndex >= cells.length) {
            int newLength;
            for (newLength = cells.length; cellIndex >= newLength; newLength *= 2) {
            }
            NetCell[] newCells = new NetCell[newLength];
            for (int i = 0; i < cells.length; ++i) {
                newCells[i] = cells[i];
            }
            cells = newCells;
        }
        NetworkTool.cells[cellIndex] = netCell;
    }

    static final NetCell getNetCell(Cell cell) {
        return cells[cell.getCellIndex()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void redoNetworkNumbering(boolean reload) {
        Job.checkChanging();
        long startTime = System.currentTimeMillis();
        if (reload) {
            NetworkTool.reload();
        }
        int ncell = 0;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cit = lib.getCells();
            while (cit.hasNext()) {
                Cell cell = (Cell)cit.next();
                ++ncell;
                cell.getNetlist(false);
            }
        }
        long endTime = System.currentTimeMillis();
        float finalTime = (float)(endTime - startTime) / 1000.0f;
        if (ncell != 0 && reload) {
            System.out.println("**** Renumber networks of " + ncell + " cells took " + finalTime + " seconds");
        }
        Object object = mutex;
        synchronized (object) {
            networksValid = true;
            mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidate() {
        Job.checkChanging();
        if (!networksValid) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            networksValid = false;
        }
    }

    public static void changesQuiet(boolean quiet) {
        if (quiet) {
            NetworkTool.invalidate();
        } else {
            NetworkTool.redoNetworkNumbering(true);
        }
    }

    public static Netlist acquireUserNetlist(Cell cell) {
        Netlist netlist = null;
        try {
            netlist = NetworkTool.getNetlist(cell, NetworkTool.isIgnoreResistors());
        }
        catch (NetlistNotReady netlistNotReady) {
            // empty catch block
        }
        return netlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Netlist getUserNetlist(Cell cell) {
        if (Thread.currentThread() == Job.databaseChangesThread) {
            NetCell netCell = NetworkTool.getNetCell(cell);
            return netCell.getNetlist(NetworkTool.isIgnoreResistors());
        }
        boolean shortResistors = NetworkTool.isIgnoreResistors();
        Object object = mutex;
        synchronized (object) {
            while (!networksValid) {
                try {
                    System.out.println("Waiting for User Netlist...");
                    mutex.wait(1000L);
                    if (networksValid) continue;
                    throw new NetlistNotReady();
                }
                catch (InterruptedException e) {
                }
                catch (NetlistNotReady e) {
                    e.printStackTrace(System.err);
                }
            }
            NetCell netCell = NetworkTool.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Netlist getNetlist(Cell cell, boolean shortResistors) {
        if (Thread.currentThread() == Job.databaseChangesThread) {
            NetCell netCell = NetworkTool.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
        Object object = mutex;
        synchronized (object) {
            if (!networksValid) {
                throw new NetlistNotReady();
            }
            NetCell netCell = NetworkTool.getNetCell(cell);
            return netCell.getNetlist(shortResistors);
        }
    }

    public void init() {
        this.setOn();
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.init()");
    }

    public void request(String cmd) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.request(" + cmd + ")");
    }

    public void examineCell(Cell cell) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.examineCell(" + cell + ")");
    }

    public void slice() {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.slice()");
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.startBatch(" + tool + "," + undoRedo + ")");
    }

    public void endBatch() {
        try {
            NetworkTool.redoNetworkNumbering(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Full Network renumbering after crash.");
            e.printStackTrace(System.out);
            System.out.println("Full Network renumbering after crash.");
            NetworkTool.redoNetworkNumbering(true);
        }
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.endBatch()");
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyNodeInst(" + ni + "," + oCX + "," + oCY + "," + oSX + "," + oSY + "," + oRot + ")");
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyNodeInsts(" + nis.length + ")");
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyArcInst(" + ai + "," + "," + oHX + "," + oTX + "," + oTY + "," + oWid + ")");
    }

    public void modifyExport(Export pp, PortInst oldPi) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyExport(" + pp + "," + oldPi + ")");
    }

    public void modifyCell(Cell cell, double oLX, double oHX, double oLY, double oHY) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyCell(" + cell + "," + oLX + "," + oHX + "," + oLY + "," + oHY + ")");
    }

    public void modifyCellGroup(Cell cell, Cell.CellGroup oCellGroup) {
        NetworkTool.invalidate();
        if (cell.isIcon() || cell.isSchematic()) {
            NetSchem.updateCellGroup(oCellGroup);
            NetSchem.updateCellGroup(cell.getCellGroup());
        }
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyCellGroup(" + cell + ",_)");
    }

    public void modifyTextDescript(ElectricObject obj, TextDescriptor descript, int oldDescript0, int oldDescript1) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyTextDescript(" + obj + ",...)");
    }

    public void newObject(ElectricObject obj) {
        NetworkTool.invalidate();
        Cell cell = obj.whichCell();
        if (obj instanceof Cell) {
            if (cell.isIcon() || cell.isSchematic()) {
                new NetSchem(cell);
            } else {
                new NetCell(cell);
            }
        } else if (obj instanceof Export) {
            NetworkTool.exportsChanged(cell);
        } else if (cell != null) {
            NetworkTool.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.newObject(" + obj + ")");
    }

    public void killObject(ElectricObject obj) {
        NetworkTool.invalidate();
        Cell cell = obj.whichCell();
        if (obj instanceof Cell) {
            NetworkTool.setCell(cell, null);
            if (cell.isIcon() || cell.isSchematic()) {
                NetSchem.updateCellGroup(cell.getCellGroup());
            }
        } else if (cell != null) {
            NetworkTool.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.killObject(" + obj + ")");
    }

    public void killExport(Export pp, Collection oldPortInsts) {
        NetworkTool.invalidate();
        Cell cell = (Cell)pp.getParent();
        NetworkTool.exportsChanged(cell);
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.killExport(" + pp + "," + oldPortInsts.size() + ")");
    }

    public void renameObject(ElectricObject obj, Name oldName, int oldVersion) {
        NetworkTool.invalidate();
        Cell cell = obj.whichCell();
        if (obj instanceof Export) {
            NetworkTool.exportsChanged(cell);
        } else if (obj instanceof Geometric && cell != null) {
            NetworkTool.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.reanameObject(" + obj + "," + oldName + "," + oldVersion + ")");
    }

    public void newVariable(ElectricObject obj, Variable var) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.newVariable(" + obj + "," + var + ")");
    }

    public void killVariable(ElectricObject obj, Variable var) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.killVariable(" + obj + "," + var + ")");
    }

    public void modifyVariableFlags(ElectricObject obj, Variable var, int oldFlags) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyVariableFlags(" + obj + "," + var + "." + oldFlags + ")");
    }

    public void modifyVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.modifyVariable(" + obj + "," + var + "," + index + "," + oldValue + ")");
    }

    public void insertVariable(ElectricObject obj, Variable var, int index) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.insertVariable(" + obj + "," + var + "," + index + ")");
    }

    public void deleteVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.deleteVariable(" + obj + "," + var + "," + index + "," + oldValue + ")");
    }

    public void readLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.readLibrary(" + lib + ")");
    }

    public void eraseLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.eraseLibrary(" + lib + ")");
    }

    public void writeLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.writeLibrary(" + lib + ")");
    }

    public static boolean isUnifyPowerAndGround() {
        return cacheUnifyPowerAndGround.getBoolean();
    }

    public static void setUnifyPowerAndGround(boolean u) {
        cacheUnifyPowerAndGround.setBoolean(u);
    }

    public static boolean isUnifyLikeNamedNets() {
        return cacheUnifyLikeNamedNets.getBoolean();
    }

    public static void setUnifyLikeNamedNets(boolean u) {
        cacheUnifyLikeNamedNets.setBoolean(u);
    }

    public static boolean isIgnoreResistors() {
        return cacheIgnoreResistors.getBoolean();
    }

    public static void setIgnoreResistors(boolean i) {
        cacheIgnoreResistors.setBoolean(i);
    }

    public static String getUnificationPrefix() {
        return cacheUnificationPrefix.getString();
    }

    public static void setUnificationPrefix(String p) {
        cacheUnificationPrefix.setString(p);
    }

    public static boolean isBusBaseZero() {
        return cacheBusBaseZero.getBoolean();
    }

    public static void setBusBaseZero(boolean z) {
        cacheBusBaseZero.setBoolean(z);
    }

    public static boolean isBusAscending() {
        return cacheBusBaseZero.getBoolean();
    }

    public static void setBusAscending(boolean a) {
        cacheBusBaseZero.setBoolean(a);
    }

    static {
        networksValid = false;
        mutex = new Object();
        errorLogger = ErrorLogger.newInstance("Network Errors", true);
        cacheUnifyPowerAndGround = Pref.makeBooleanPref("UnifyPowerAndGround", NetworkTool.tool.prefs, false);
        cacheUnifyPowerAndGround.attachToObject(tool, "Tools/Network tab", "Networks unify Power and Ground");
        cacheUnifyLikeNamedNets = Pref.makeBooleanPref("UnifyLikeNamedNets", NetworkTool.tool.prefs, false);
        cacheUnifyLikeNamedNets.attachToObject(tool, "Tools/Network tab", "Networks unify all like-named nets");
        cacheIgnoreResistors = Pref.makeBooleanPref("IgnoreResistors", NetworkTool.tool.prefs, false);
        cacheIgnoreResistors.attachToObject(tool, "Tools/Network tab", "Networks ignore Resistors");
        cacheUnificationPrefix = Pref.makeStringPref("UnificationPrefix", NetworkTool.tool.prefs, "");
        cacheUnificationPrefix.attachToObject(tool, "Tools/Network tab", "Network unification prefix");
        cacheBusBaseZero = Pref.makeBooleanPref("BusBaseZero", NetworkTool.tool.prefs, false);
        cacheBusBaseZero.attachToObject(tool, "Tools/Network tab", "Default busses starting index");
        cacheBusAscending = Pref.makeBooleanPref("BusAscending", NetworkTool.tool.prefs, false);
        cacheBusAscending.attachToObject(tool, "Tools/Network tab", "Default busses are ascending");
    }

    public static class RenumberJob
    extends Job {
        public RenumberJob() {
            super("Renumber All Networks", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            NetworkTool.redoNetworkNumbering(true);
            return true;
        }
    }

    public static class NetlistNotReady
    extends RuntimeException {
        public NetlistNotReady() {
            super("User netlist is not ready");
        }

        public NetlistNotReady(String s) {
            super(s);
        }
    }
}

