/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WiringListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    public static WiringListener theOne = new WiringListener();
    private Point2D startPoint;
    private ElectricObject startObj;
    private Geometric startGeom;
    private PortProto startPort;
    private WiringPlan[] wpStartList;
    private Point2D endPoint;
    private ElectricObject endObj;
    private Geometric endGeom;
    private PortProto endPort;
    private Cell cellBeingWired;
    private boolean doingWiringDrag;
    private static AudioClip clickSound = null;

    private WiringListener() {
    }

    public void mousePressed(MouseEvent evt) {
        int startx = evt.getX();
        int starty = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        this.startPoint = wnd.screenToDatabase(startx, starty);
        boolean another = false;
        if ((evt.getModifiers() & 2) != 0) {
            another = true;
        }
        if (evt.getClickCount() == 2 && !another && Highlight.getNumHighlights() >= 1) {
            EditMenu.getInfoCommand();
            return;
        }
        this.doingWiringDrag = false;
        if (!another && Highlight.overHighlighted(wnd, startx, starty)) {
            Highlight high = (Highlight)Highlight.getHighlights().next();
            if (high == null) {
                return;
            }
            if (high.getType() != Highlight.Type.EOBJ) {
                return;
            }
            ElectricObject eobj = high.getElectricObject();
            this.startPort = null;
            if (eobj instanceof PortInst) {
                this.startPort = ((PortInst)eobj).getPortProto();
                eobj = ((PortInst)eobj).getNodeInst();
            }
            this.startObj = eobj;
            this.startGeom = (Geometric)eobj;
            this.cellBeingWired = this.startGeom.getParent();
            this.doingWiringDrag = true;
        } else {
            Highlight high;
            Highlight.findObject(this.startPoint, wnd, false, another, false, true, false, false, false);
            if (Highlight.getNumHighlights() == 1 && (high = (Highlight)Highlight.getHighlights().next()).getType() == Highlight.Type.EOBJ) {
                ElectricObject eobj = high.getElectricObject();
                this.startPort = null;
                if (eobj instanceof PortInst) {
                    this.startPort = ((PortInst)eobj).getPortProto();
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                this.startObj = eobj;
                this.startGeom = (Geometric)eobj;
                this.cellBeingWired = this.startGeom.getParent();
                this.doingWiringDrag = true;
            }
        }
        if (this.doingWiringDrag) {
            this.wpStartList = WiringPlan.getClosestEnd(this.startGeom, this.startPort, this.startPoint, this.startPoint);
            if (this.wpStartList == null) {
                System.out.println("ERROR: Cannot run arcs from " + this.startGeom.describe());
                this.doingWiringDrag = false;
            }
        }
        wnd.repaint();
    }

    public void mouseDragged(MouseEvent evt) {
        if (!this.doingWiringDrag) {
            return;
        }
        if (!(evt.getSource() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)evt.getSource();
        this.getEndObject(evt.getX(), evt.getY(), wnd);
        WiringPlan[] wpEndList = WiringPlan.getClosestEnd(this.endGeom, this.endPort, this.endPoint, this.startPoint);
        WiringPlan[] curPath = WiringPlan.getWiringPlan(this.wpStartList, wpEndList, this.endPoint);
        if (curPath == null) {
            return;
        }
        Highlight.clear();
        Highlight h = Highlight.addElectricObject(this.startObj, this.startGeom.getParent());
        WiringPlan wpEnd = null;
        for (int i = 0; i < curPath.length; ++i) {
            WiringPlan wp = curPath[i];
            if (wp.getType() == Type.ARCADD) {
                Point2D headLoc = wp.getArcHeadLocation();
                Point2D tailLoc = wp.getArcTailLocation();
                Highlight.addLine(headLoc, tailLoc, this.cellBeingWired);
            }
            if (wp.getType() != Type.NODEADD) continue;
            wpEnd = wp;
        }
        if (wpEnd != null) {
            SizeOffset so = wpEnd.getNodeType().getProtoSizeOffset();
            double cx = wpEnd.getNodeLocation().getX();
            double cy = wpEnd.getNodeLocation().getY();
            double sx = wpEnd.getNodeWidth();
            double sy = wpEnd.getNodeHeight();
            double lx = cx - sx / 2.0 + so.getLowXOffset();
            double hx = cx + sx / 2.0 - so.getLowXOffset();
            double ly = cy - sy / 2.0 + so.getLowYOffset();
            double hy = cy + sy / 2.0 - so.getLowYOffset();
            Rectangle2D.Double highlight = new Rectangle2D.Double(lx, ly, hx - lx, hy - ly);
            Highlight.addArea(highlight, this.cellBeingWired);
        }
        Highlight.finished();
        wnd.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.doingWiringDrag) {
            return;
        }
        this.doingWiringDrag = false;
        EditWindow wnd = (EditWindow)evt.getSource();
        this.getEndObject(evt.getX(), evt.getY(), wnd);
        WiringPlan[] wpEndList = WiringPlan.getClosestEnd(this.endGeom, this.endPort, this.endPoint, this.startPoint);
        WiringPlan[] curPath = WiringPlan.getWiringPlan(this.wpStartList, wpEndList, this.endPoint);
        if (curPath == null) {
            return;
        }
        RealizeWiring job = new RealizeWiring(curPath, this.cellBeingWired);
        wnd.repaintContents(null);
    }

    public static List makeConnection(NodeInst fromNi, PortProto fromPP, NodeInst toNi, PortProto toPP, Point2D pt, boolean nozigzag, boolean report) {
        WiringPlan[] endList;
        WiringPlan[] startList = WiringPlan.getClosestEnd(fromNi, fromPP, pt, pt);
        WiringPlan[] curPath = WiringPlan.getWiringPlan(startList, endList = WiringPlan.getClosestEnd(toNi, toPP, pt, pt), pt);
        if (curPath == null) {
            return null;
        }
        List added = WiringListener.doWiring(curPath, fromNi.getParent(), report);
        return added;
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        if (chr == 127 || chr == 8) {
            CircuitChanges.deleteSelected();
        }
        if (chr == 65) {
            this.doingWiringDrag = false;
            Highlight.clear();
            Highlight h = Highlight.addElectricObject(this.startObj, this.startGeom.getParent());
            Highlight.finished();
            wnd.repaint();
            System.out.println("Aborted");
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void getEndObject(int endX, int endY, EditWindow wnd) {
        this.endPoint = wnd.screenToDatabase(endX, endY);
        this.endObj = null;
        this.endGeom = null;
        this.endPort = null;
        Rectangle2D.Double bounds = new Rectangle2D.Double(this.endPoint.getX(), this.endPoint.getY(), 0.0, 0.0);
        List underCursor = Highlight.findAllInArea(this.cellBeingWired, false, false, true, false, false, false, bounds, wnd);
        Iterator it = underCursor.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                this.endPort = ((PortInst)eobj).getPortProto();
                eobj = ((PortInst)eobj).getNodeInst();
            }
            this.endGeom = (Geometric)eobj;
            break;
        }
    }

    private static Point2D figureCenter(Object obj, PortProto pp, Point2D preferred) {
        WiringPlan wp;
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            Poly poly = ni.getShapeOfPort(pp, preferred, false);
            return new Point2D.Double(poly.getCenterX(), poly.getCenterY());
        }
        if (obj instanceof WiringPlan && (wp = (WiringPlan)obj).getType() == Type.NODEADD) {
            return wp.getNodeLocation();
        }
        return null;
    }

    private static List doWiring(WiringPlan[] wpList, Cell cell, boolean report) {
        ArrayList<Geometric> added = new ArrayList<Geometric>();
        WiringPlan wpEnd = null;
        int arcsCreated = 0;
        int nodesCreated = 0;
        ArcProto defArc = User.tool.getCurrentArcProto();
        ArcProto otherArc = null;
        Geometric lastPlacedArc = null;
        boolean madeDefArcs = false;
        for (int i = 0; i < wpList.length; ++i) {
            WiringPlan wp = wpList[i];
            if (wp.getType() == Type.NODEADD && wp.getNodeObject() == null) {
                NodeInst newNi = NodeInst.makeInstance(wp.getNodeType(), wp.getNodeLocation(), wp.getNodeWidth(), wp.getNodeHeight(), 0, cell, null);
                if (newNi == null) {
                    return null;
                }
                added.add(newNi);
                ++nodesCreated;
                wp.setNodeObject(newNi);
                wpEnd = wp;
            }
            if (wp.getType() == Type.ARCADD) {
                Object headObj = wp.getArcHeadObject();
                NodeInst headNi = headObj instanceof NodeInst ? (NodeInst)headObj : (NodeInst)((WiringPlan)headObj).getNodeObject();
                PortInst headPi = headNi.findPortInstFromProto(wp.getArcHeadPortProto());
                Object tailObj = wp.getArcTailObject();
                NodeInst tailNi = tailObj instanceof NodeInst ? (NodeInst)tailObj : (NodeInst)((WiringPlan)tailObj).getNodeObject();
                PortInst tailPi = tailNi.findPortInstFromProto(wp.getArcTailPortProto());
                ArcProto ap = wp.getArcType();
                if (ap == null) {
                    System.out.println("Arc proto null");
                    return null;
                }
                Point2D headLoc = wp.getArcHeadLocation();
                Point2D tailLoc = wp.getArcTailLocation();
                ArcInst newAi = ArcInst.makeInstance(ap, wp.getArcWidth(), headPi, headLoc, tailPi, tailLoc, null);
                if (newAi == null) {
                    return null;
                }
                ++arcsCreated;
                added.add(newAi);
                lastPlacedArc = newAi;
                if (newAi.getProto() == defArc) {
                    madeDefArcs = true;
                } else {
                    otherArc = newAi.getProto();
                }
            }
            if (wp.getType() != Type.ARCDEL) continue;
            ArcInst ai = wp.getArc();
            ai.kill();
        }
        if (otherArc != null && !madeDefArcs) {
            User.tool.setCurrentArcProto(otherArc);
        }
        if (report) {
            Highlight.clear();
            if (wpEnd != null) {
                NodeInst ni = (NodeInst)wpEnd.getNodeObject();
                Highlight.addElectricObject(ni, ni.getParent());
            } else if (lastPlacedArc != null) {
                Highlight.addElectricObject(lastPlacedArc, lastPlacedArc.getParent());
            }
            if (arcsCreated != 0 || nodesCreated != 0) {
                String msg = "Created ";
                if (arcsCreated != 0) {
                    msg = msg + arcsCreated + " arcs";
                }
                if (nodesCreated != 0) {
                    msg = msg + " and " + nodesCreated + " nodes";
                }
                System.out.println(msg);
                WiringListener.playSound(arcsCreated);
            }
            Highlight.finished();
        }
        return added;
    }

    private static void playSound(int arcsCreated) {
        if (User.isPlayClickSoundsWhenCreatingArcs()) {
            URL url = WiringListener.class.getResource("Click.wav");
            if (url == null) {
                return;
            }
            if (clickSound == null) {
                clickSound = Applet.newAudioClip(url);
            }
            clickSound.play();
        }
    }

    private static class WiringPlan {
        private Type type;
        private NodeProto pinType;
        private PortProto pinPort;
        private Object pin;
        private Point2D pinLocation;
        private double pinWidth;
        private double pinHeight;
        private ArcProto arcType;
        private ArcInst arc;
        private Object arcHeadObj;
        private PortProto arcHeadPort;
        private Point2D arcHeadLoc;
        private Object arcTailObj;
        private PortProto arcTailPort;
        private Point2D arcTailLoc;
        private double arcWidth;

        private WiringPlan() {
        }

        public Type getType() {
            return this.type;
        }

        public void setNodeObject(Object obj) {
            this.pin = obj;
        }

        public Object getNodeObject() {
            return this.pin;
        }

        public PortProto getNodePort() {
            return this.pinPort;
        }

        public NodeProto getNodeType() {
            return this.pinType;
        }

        public Point2D getNodeLocation() {
            return this.pinLocation;
        }

        public double getNodeWidth() {
            return this.pinWidth;
        }

        public double getNodeHeight() {
            return this.pinHeight;
        }

        public ArcProto getArcType() {
            return this.arcType;
        }

        public ArcInst getArc() {
            return this.arc;
        }

        public Object getArcHeadObject() {
            return this.arcHeadObj;
        }

        public PortProto getArcHeadPortProto() {
            return this.arcHeadPort;
        }

        public Point2D getArcHeadLocation() {
            return this.arcHeadLoc;
        }

        public Object getArcTailObject() {
            return this.arcTailObj;
        }

        public PortProto getArcTailPortProto() {
            return this.arcTailPort;
        }

        public Point2D getArcTailLocation() {
            return this.arcTailLoc;
        }

        public double getArcWidth() {
            return this.arcWidth;
        }

        static WiringPlan makeNode(Object pin, NodeProto type, PortProto port, Point2D location, double width, double height) {
            WiringPlan wp = new WiringPlan();
            wp.type = Type.NODEADD;
            wp.pin = pin;
            wp.pinType = type;
            wp.pinPort = port;
            wp.pinLocation = location;
            wp.pinWidth = width;
            wp.pinHeight = height;
            return wp;
        }

        static WiringPlan makeArc(ArcProto type, Object arcHeadObj, PortProto arcHeadPort, Point2D arcHeadLoc, Object arcTailObj, PortProto arcTailPort, Point2D arcTailLoc, double width) {
            WiringPlan wp = new WiringPlan();
            wp.type = Type.ARCADD;
            wp.arcType = type;
            wp.arcHeadObj = arcHeadObj;
            wp.arcHeadPort = arcHeadPort;
            wp.arcHeadLoc = arcHeadLoc;
            wp.arcTailObj = arcTailObj;
            wp.arcTailPort = arcTailPort;
            wp.arcTailLoc = arcTailLoc;
            wp.arcWidth = width;
            return wp;
        }

        static WiringPlan killArc(ArcInst ai) {
            WiringPlan wp = new WiringPlan();
            wp.type = Type.ARCDEL;
            wp.arc = ai;
            return wp;
        }

        static WiringPlan[] getWiringPath(WiringPlan start, ArcProto startAp, WiringPlan end, ArcProto endAp) {
            Point2D.Double startLoc = new Point2D.Double();
            if (start.getNodeObject() == null) {
                startLoc.setLocation(start.getNodeLocation());
            } else {
                startLoc.setLocation(WiringListener.figureCenter(start.getNodeObject(), start.getNodePort(), start.getNodeLocation()));
            }
            Point2D.Double endLoc = new Point2D.Double();
            if (end.getNodeObject() == null) {
                endLoc.setLocation(end.getNodeLocation());
            } else {
                endLoc.setLocation(WiringListener.figureCenter(end.getNodeObject(), end.getNodePort(), end.getNodeLocation()));
            }
            if (DBMath.doublesEqual(((Point2D)startLoc).getX(), ((Point2D)endLoc).getX()) || DBMath.doublesEqual(((Point2D)startLoc).getY(), ((Point2D)endLoc).getY())) {
                WiringPlan[] list = new WiringPlan[]{WiringPlan.makeArc(startAp, start, start.getNodePort(), startLoc, end, end.getNodePort(), endLoc, startAp.getWidth())};
                return list;
            }
            WiringPlan[] list = new WiringPlan[3];
            Point2D.Double intermediate = new Point2D.Double(((Point2D)startLoc).getX(), ((Point2D)endLoc).getY());
            PrimitiveNode np = ((PrimitiveArc)startAp).findOverridablePinProto();
            PrimitivePort pp = (PrimitivePort)np.getPorts().next();
            list[0] = WiringPlan.makeNode(null, np, pp, intermediate, np.getDefWidth(), np.getDefHeight());
            list[1] = WiringPlan.makeArc(startAp, list[0], pp, intermediate, end, end.getNodePort(), endLoc, startAp.getWidth());
            list[2] = WiringPlan.makeArc(startAp, start, start.getNodePort(), startLoc, list[0], pp, intermediate, startAp.getWidth());
            return list;
        }

        static WiringPlan[] getClosestEnd(Geometric geom, PortProto port, Point2D point, Point2D startPoint) {
            if (geom instanceof NodeInst) {
                PortInst pi;
                NodeInst ni = (NodeInst)geom;
                if (port == null) {
                    pi = ni.findClosestPortInst(point);
                    if (pi == null) {
                        return null;
                    }
                    port = pi.getPortProto();
                }
                pi = ni.findPortInstFromProto(port);
                Poly portPoly = pi.getPoly();
                Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
                WiringPlan[] list = new WiringPlan[]{WiringPlan.makeNode(ni, ni.getProto(), port, portCenter, ni.getXSize(), ni.getYSize())};
                return list;
            }
            if (geom instanceof ArcInst) {
                ArcInst ai = (ArcInst)geom;
                Connection aiHead = ai.getHead();
                Connection aiTail = ai.getTail();
                Poly poly = ai.makePoly(ai.getLength(), ai.getWidth(), Poly.Type.FILLED);
                if (poly.isInside(point)) {
                    WiringPlan[] list;
                    if (aiHead.getLocation().distance(point) < ai.getWidth()) {
                        PortInst pi = aiHead.getPortInst();
                        NodeInst ni = pi.getNodeInst();
                        WiringPlan[] list2 = new WiringPlan[]{WiringPlan.makeNode(ni, ni.getProto(), pi.getPortProto(), ni.getTrueCenter(), ni.getXSize(), ni.getYSize())};
                        return list2;
                    }
                    if (aiTail.getLocation().distance(point) < ai.getWidth()) {
                        PortInst pi = aiTail.getPortInst();
                        NodeInst ni = pi.getNodeInst();
                        WiringPlan[] list3 = new WiringPlan[]{WiringPlan.makeNode(ni, ni.getProto(), pi.getPortProto(), ni.getTrueCenter(), ni.getXSize(), ni.getYSize())};
                        return list3;
                    }
                    PrimitiveNode np = ((PrimitiveArc)ai.getProto()).findOverridablePinProto();
                    PrimitivePort pp = (PrimitivePort)np.getPorts().next();
                    Point2D center = DBMath.closestPointToSegment(aiHead.getLocation(), aiTail.getLocation(), startPoint);
                    EditWindow.gridAlign(center);
                    list = new WiringPlan[]{WiringPlan.makeNode(null, np, pp, center, np.getDefWidth(), np.getDefHeight()), WiringPlan.makeArc(ai.getProto(), aiHead.getPortInst().getNodeInst(), aiHead.getPortInst().getPortProto(), aiHead.getLocation(), list[0], pp, center, ai.getWidth()), WiringPlan.makeArc(ai.getProto(), list[0], pp, center, aiTail.getPortInst().getNodeInst(), aiTail.getPortInst().getPortProto(), aiTail.getLocation(), ai.getWidth()), WiringPlan.killArc(ai)};
                    return list;
                }
                PortInst pi = null;
                pi = point.distance(aiHead.getLocation()) < point.distance(aiTail.getLocation()) ? aiHead.getPortInst() : aiTail.getPortInst();
                NodeInst ni = pi.getNodeInst();
                WiringPlan[] list = new WiringPlan[]{WiringPlan.makeNode(ni, ni.getProto(), pi.getPortProto(), ni.getTrueCenter(), ni.getXSize(), ni.getYSize())};
                return list;
            }
            return null;
        }

        public static ArcProto getArcConnectedToPort(PrimitivePort pp) {
            ArcProto curAp = User.tool.getCurrentArcProto();
            if (pp.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp.connectsTo(ap)) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    PrimitiveArc ap = (PrimitiveArc)aIt.next();
                    if (!pp.connectsTo(ap)) continue;
                    return ap;
                }
            }
            return null;
        }

        public static ArcProto getArcConnectedToPorts(PrimitivePort pp1, PrimitivePort pp2) {
            ArcProto curAp = User.tool.getCurrentArcProto();
            if (pp1.connectsTo(curAp) && pp2.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap)) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    PrimitiveArc ap = (PrimitiveArc)aIt.next();
                    if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap)) continue;
                    return ap;
                }
            }
            return null;
        }

        public static WiringPlan[] getWiringPlan(WiringPlan[] wpStartList, WiringPlan[] wpEndList, Point2D endPt) {
            int j;
            ArcProto useAp;
            WiringPlan wpStart = wpStartList[0];
            if (wpEndList == null) {
                ArcProto useAp2;
                WiringPlan wp = wpStartList[0];
                NodeProto np = wp.getNodeType();
                PrimitivePort pp = null;
                if (wp.getNodePort() != null) {
                    pp = wp.getNodePort().getBasePort();
                }
                if (pp == null) {
                    pp = ((PortProto)np.getPorts().next()).getBasePort();
                }
                if ((useAp2 = WiringPlan.getArcConnectedToPort(pp)) == null) {
                    return null;
                }
                Point2D.Double trueEnd = new Point2D.Double();
                int angleInc = ((PrimitiveArc)useAp2).getAngleIncrement();
                if (angleInc == 0) {
                    trueEnd.setLocation(endPt);
                } else {
                    Point2D center = wpStart.getNodeLocation();
                    double bestDist = Double.MAX_VALUE;
                    for (int a = 0; a < 360; a += angleInc) {
                        Point2D.Double radialEnd = new Point2D.Double(center.getX() + Math.cos((double)a * Math.PI / 180.0), center.getY() + Math.sin((double)a * Math.PI / 180.0));
                        Point2D closestToRadial = DBMath.closestPointToLine(center, radialEnd, endPt);
                        double thisDist = closestToRadial.distance(endPt);
                        if (!(thisDist < bestDist)) continue;
                        bestDist = thisDist;
                        trueEnd.setLocation(closestToRadial);
                    }
                }
                EditWindow.gridAlign(trueEnd);
                PrimitiveNode pinType = ((PrimitiveArc)useAp2).findOverridablePinProto();
                PrimitivePort pinPort = (PrimitivePort)pinType.getPorts().next();
                WiringPlan[] returnValue = new WiringPlan[wpStartList.length + 2];
                int i = 0;
                for (int j2 = 0; j2 < wpStartList.length; ++j2) {
                    returnValue[i++] = wpStartList[j2];
                }
                WiringPlan endNode = WiringPlan.makeNode(null, pinType, pinPort, trueEnd, pinType.getDefWidth(), pinType.getDefHeight());
                returnValue[i++] = endNode;
                returnValue[i++] = WiringPlan.makeArc(useAp2, returnValue[0], wp.getNodePort(), wp.getNodeLocation(), endNode, pinPort, trueEnd, useAp2.getDefaultWidth());
                return returnValue;
            }
            WiringPlan wpEnd = wpEndList[0];
            if (wpStart.getNodeObject() == wpEnd.getNodeObject() && wpStart.getNodeObject() != null && wpStart.getNodePort() == wpEnd.getNodePort()) {
                return null;
            }
            NodeProto npStart = wpStart.getNodeType();
            PrimitivePort ppStart = null;
            if (wpStart.getNodePort() != null) {
                ppStart = wpStart.getNodePort().getBasePort();
            }
            if (ppStart == null) {
                ppStart = ((PortProto)npStart.getPorts().next()).getBasePort();
            }
            NodeProto npEnd = wpEnd.getNodeType();
            PrimitivePort ppEnd = null;
            if (wpEnd.getNodePort() != null) {
                ppEnd = wpEnd.getNodePort().getBasePort();
            }
            if (ppEnd == null) {
                ppEnd = ((PortProto)npEnd.getPorts().next()).getBasePort();
            }
            if ((useAp = WiringPlan.getArcConnectedToPorts(ppStart, ppEnd)) == null) {
                return null;
            }
            WiringPlan[] inbetween = WiringPlan.getWiringPath(wpStartList[0], useAp, wpEndList[0], useAp);
            if (inbetween == null) {
                return null;
            }
            WiringPlan[] returnValue = new WiringPlan[wpStartList.length + inbetween.length + wpEndList.length];
            int i = 0;
            for (j = 0; j < wpStartList.length; ++j) {
                returnValue[i++] = wpStartList[j];
            }
            for (j = 0; j < wpEndList.length; ++j) {
                returnValue[i++] = wpEndList[j];
            }
            for (j = 0; j < inbetween.length; ++j) {
                returnValue[i++] = inbetween[j];
            }
            return returnValue;
        }
    }

    public static class Type {
        private final String name;
        public static final Type NODEADD = new Type("add node");
        public static final Type ARCADD = new Type("add arc");
        public static final Type ARCDEL = new Type("delete arc");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class RealizeWiring
    extends Job {
        WiringPlan[] wpList;
        Cell cell;

        protected RealizeWiring(WiringPlan[] wpList, Cell cell) {
            super("Wiring", User.tool, Job.Type.CHANGE, cell, null, Job.Priority.USER);
            this.wpList = wpList;
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            WiringListener.doWiring(this.wpList, this.cell, true);
            return true;
        }
    }
}

