/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Iterator;

public class PixelDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    private static final boolean TAKE_STATS = false;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreensUsed;
    private EditWindow wnd;
    private Dimension sz;
    private Image img;
    private int[] opaqueData;
    private int total;
    private int backgroundColor;
    private int backgroundValue;
    private byte[][][] layerBitMaps;
    private byte[][] compositeRows;
    private int numLayerBitMaps;
    private int numBytesPerRow;
    private int numLayerBitMapsCreated;
    private Technology curTech;
    private HashMap patternedOpaqueLayers;
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private static Dimension topSz;
    private static Technology techWithLayers;
    private static HashMap expandedCells;
    private static TextDescriptor noCellTextDescriptor;
    private static final Rectangle2D CENTERRECT;
    private static EGraphics blackGraphics;
    private static EGraphics portGraphics;
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private int arcCol;
    private byte[][] arcLayerBitMap;
    private boolean arcThick;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;

    public PixelDrawing(EditWindow wnd) {
        this.wnd = wnd;
        this.sz = wnd.getScreenSize();
        this.img = new BufferedImage(this.sz.width, this.sz.height, 1);
        WritableRaster raster = ((BufferedImage)this.img).getRaster();
        DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
        this.opaqueData = dbi.getData();
        this.total = this.sz.height * this.sz.width;
        this.numBytesPerRow = (this.sz.width + 7) / 8;
        this.backgroundColor = User.getColorBackground() & 0xFFFFFF;
        this.backgroundValue = this.backgroundColor | 0xFF000000;
        this.patternedOpaqueLayers = new HashMap();
        this.renderedWindow = true;
        this.curTech = null;
        this.initForTechnology();
        this.clearImage(false);
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg.getRGB() & 0xFFFFFF;
    }

    public Image getImage() {
        return this.img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Rectangle2D bounds) {
        Cell cell = this.wnd.getCell();
        long startTime = 0L;
        expandedCells = new HashMap();
        topSz = this.sz;
        this.clearImage(true);
        if (cell == null) {
            if (noCellTextDescriptor == null) {
                noCellTextDescriptor = new TextDescriptor(null);
                noCellTextDescriptor.setAbsSize(18);
                noCellTextDescriptor.setBold(true);
            }
            Rectangle rect = new Rectangle(this.sz);
            blackGraphics.setColor(new Color(User.getColorText()));
            this.drawText(rect, Poly.Type.TEXTBOX, noCellTextDescriptor, "No cell in this window", null, blackGraphics);
        } else {
            this.countCell(cell, DBMath.MATID);
            this.drawCell(cell, bounds, DBMath.MATID, true);
        }
        Image image = this.img;
        synchronized (image) {
            this.composite();
        }
    }

    public void clearImage(boolean periodicRefresh) {
        this.initForTechnology();
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            byte[][] layerBitMap = this.layerBitMaps[i];
            if (layerBitMap == null) continue;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        Iterator it = this.patternedOpaqueLayers.entrySet().iterator();
        while (it.hasNext()) {
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)((Object)it.next());
            byte[][] layerBitMap = pol.bitMap;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        for (int i = 0; i < this.total; ++i) {
            this.opaqueData[i] = this.backgroundValue;
        }
        this.periodicRefresh = periodicRefresh;
        if (periodicRefresh) {
            this.objectCount = 0;
            this.lastRefreshTime = System.currentTimeMillis();
        }
    }

    public Image composite() {
        if (this.numLayerBitMapsCreated > 0) {
            Color[] colorMap = this.curTech.getColorMap();
            for (int y = 0; y < this.sz.height; ++y) {
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] layerBitMap = this.layerBitMaps[i];
                    this.compositeRows[i] = (byte[])(layerBitMap == null ? null : layerBitMap[y]);
                }
                int baseIndex = y * this.sz.width;
                for (int x = 0; x < this.sz.width; ++x) {
                    int index = baseIndex + x;
                    int pixelValue = this.opaqueData[index];
                    int alpha = pixelValue >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    int bits = 0;
                    int entry = x >> 3;
                    int maskBit = 1 << (x & 7);
                    for (int i = 0; i < this.numLayerBitMaps; ++i) {
                        byte byt;
                        if (this.compositeRows[i] == null || ((byt = this.compositeRows[i][entry]) & maskBit) == 0) continue;
                        bits |= 1 << i;
                    }
                    int newColor = this.backgroundColor;
                    if (bits != 0) {
                        newColor = colorMap[bits].getRGB() & 0xFFFFFF;
                    }
                    if (alpha != 255) {
                        newColor = this.alphaBlend(pixelValue, newColor, alpha);
                    }
                    this.opaqueData[index] = newColor;
                }
            }
        } else {
            for (int i = 0; i < this.total; ++i) {
                int pixelValue = this.opaqueData[i];
                if (pixelValue == this.backgroundValue) {
                    this.opaqueData[i] = this.backgroundColor;
                    continue;
                }
                if ((pixelValue & 0xFF000000) == 0) continue;
                int alpha = pixelValue >> 24 & 0xFF;
                this.opaqueData[i] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
            }
        }
        return this.img;
    }

    private void initForTechnology() {
        Technology tech = Technology.getCurrent();
        if (tech == null) {
            return;
        }
        if (tech == this.curTech) {
            return;
        }
        int transLayers = tech.getNumTransparentLayers();
        if (transLayers != 0) {
            techWithLayers = this.curTech = tech;
        }
        if (this.curTech == null) {
            this.curTech = techWithLayers;
        }
        this.numLayerBitMaps = this.curTech.getNumTransparentLayers();
        this.layerBitMaps = new byte[this.numLayerBitMaps][][];
        this.compositeRows = new byte[this.numLayerBitMaps][];
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            this.layerBitMaps[i] = null;
        }
        this.numLayerBitMapsCreated = 0;
    }

    private void drawCell(Cell cell, Rectangle2D bounds, AffineTransform prevTrans, boolean topLevel) {
        Iterator arcs = cell.getArcs();
        while (arcs.hasNext()) {
            this.drawArc((ArcInst)arcs.next(), prevTrans);
        }
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            this.drawNode((NodeInst)nodes.next(), prevTrans, topLevel, bounds);
        }
        if (topLevel && User.isTextVisibilityOnCell()) {
            int numPolys = cell.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            cell.addDisplayableVariables(CENTERRECT, polys, 0, this.wnd, true);
            this.drawPolys(polys, DBMath.MATID);
        }
    }

    public void drawNode(NodeInst ni, AffineTransform trans, boolean topLevel, Rectangle2D bounds) {
        Rectangle2D rect;
        Poly[] polys;
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        Point2D ctr = ni.getTrueCenter();
        trans.transform(ctr, ctr);
        double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
        Rectangle2D databaseBounds = this.wnd.getDisplayedBounds();
        double ctrX = ctr.getX();
        double ctrY = ctr.getY();
        if (ctrX + halfWidth < databaseBounds.getMinX()) {
            return;
        }
        if (ctrX - halfWidth > databaseBounds.getMaxX()) {
            return;
        }
        if (ctrY + halfWidth < databaseBounds.getMinY()) {
            return;
        }
        if (ctrY - halfWidth > databaseBounds.getMaxY()) {
            return;
        }
        if (np instanceof Cell) {
            ++totalCells;
        } else {
            ++totalPrims;
        }
        if (!np.isCanBeZeroSize() && halfWidth * this.wnd.getScale() < 1.0) {
            if (np instanceof Cell) {
                ++tinyCells;
            } else {
                ++tinyPrims;
                int x = this.wnd.databaseToScreenX(ctrX);
                int y = this.wnd.databaseToScreenY(ctrY);
                if (x >= 0 && x < this.sz.width && y >= 0 && y < this.sz.height) {
                    this.drawTinyLayers(((PrimitiveNode)np).layerIterator(), x, y);
                }
            }
            return;
        }
        if (np instanceof Cell) {
            Cell subCell = (Cell)np;
            boolean expanded = ni.isExpanded();
            if (bounds != null && ni.getBounds().intersects(bounds)) {
                expanded = true;
                AffineTransform transRI = ni.rotateIn();
                AffineTransform transTI = ni.translateIn();
                transRI.preConcatenate(transTI);
                Rectangle2D.Double subBounds = new Rectangle2D.Double();
                ((Rectangle2D)subBounds).setRect(bounds);
                DBMath.transformRect(subBounds, transRI);
                bounds = subBounds;
            }
            if (expanded) {
                AffineTransform subTrans = ni.translateOut(localTrans);
                if (this.expandedCellCached(subCell, subTrans, bounds)) {
                    return;
                }
                this.drawCell(subCell, bounds, subTrans, false);
                this.showCellPorts(ni, trans, Color.BLACK);
            } else {
                this.drawUnexpandedCell(ni, trans);
                this.showCellPorts(ni, trans, null);
            }
            if (User.isTextVisibilityOnNode()) {
                int numPolys = ni.numDisplayableVariables(true);
                polys = new Poly[numPolys];
                rect = ni.getBounds();
                ni.addDisplayableVariables(rect, polys, 0, this.wnd, true);
                this.drawPolys(polys, localTrans);
            }
        } else if (topLevel || !ni.isVisInside()) {
            EditWindow nodeWnd = this.wnd;
            PrimitiveNode prim = (PrimitiveNode)np;
            if (!User.isTextVisibilityOnNode()) {
                nodeWnd = null;
            }
            if (prim == Generic.tech.invisiblePinNode && !User.isTextVisibilityOnAnnotation()) {
                nodeWnd = null;
            }
            Technology tech = prim.getTechnology();
            polys = tech.getShapeOfNode(ni, nodeWnd);
            this.drawPolys(polys, localTrans);
        }
        if (topLevel && User.isTextVisibilityOnExport()) {
            int exportDisplayLevel = User.getExportDisplayLevel();
            Iterator it = ni.getExports();
            blackGraphics.setColor(new Color(User.getColorText()));
            while (it.hasNext()) {
                int numPolys;
                Export e = (Export)it.next();
                Poly poly = e.getNamePoly();
                rect = (Rectangle2D)poly.getBounds2D().clone();
                if (exportDisplayLevel == 2) {
                    this.drawCross(poly, blackGraphics);
                } else {
                    TextDescriptor descript = poly.getTextDescriptor();
                    Poly.Type type = descript.getPos().getPolyType();
                    String portName = e.getName();
                    if (exportDisplayLevel == 1) {
                        portName = e.getShortName();
                    }
                    Point pt = this.wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                    Rectangle textRect = new Rectangle(pt);
                    type = Poly.rotateType(type, ni);
                    this.drawText(textRect, type, descript, portName, null, blackGraphics);
                }
                if ((numPolys = e.numDisplayableVariables(true)) <= 0) continue;
                Poly[] polys2 = new Poly[numPolys];
                e.addDisplayableVariables(rect, polys2, 0, this.wnd, true);
                this.drawPolys(polys2, localTrans);
            }
        }
    }

    public void drawArc(ArcInst ai, AffineTransform trans) {
        Rectangle2D arcBounds = ai.getBounds();
        double arcSize = Math.max(arcBounds.getWidth(), arcBounds.getHeight());
        ++totalArcs;
        if (arcSize * this.wnd.getScale() < 2.0) {
            ++tinyArcs;
            Point2D ctr = ai.getTrueCenter();
            trans.transform(ctr, ctr);
            int x = this.wnd.databaseToScreenX(ctr.getX());
            int y = this.wnd.databaseToScreenY(ctr.getY());
            if (x >= 0 && x < this.sz.width && y >= 0 && y < this.sz.height) {
                PrimitiveArc prim = (PrimitiveArc)ai.getProto();
                this.drawTinyLayers(prim.layerIterator(), x, y);
            }
            return;
        }
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        EditWindow arcWnd = this.wnd;
        if (!User.isTextVisibilityOnArc()) {
            arcWnd = null;
        }
        Poly[] polys = tech.getShapeOfArc(ai, arcWnd);
        this.drawPolys(polys, trans);
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, Color col) {
        PortInst pi;
        FlagSet fs = PortProto.getFlagSet(1);
        Iterator it = ni.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = (PortProto)it.next();
            pp.clearBit(fs);
        }
        it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            pi = con.getPortInst();
            pi.getPortProto().setBit(fs);
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            pi.getPortProto().setBit(fs);
        }
        int portDisplayLevel = User.getPortDisplayLevel();
        Iterator it2 = ni.getProto().getPorts();
        while (it2.hasNext()) {
            Poly portPoly;
            PortProto pp = (PortProto)it2.next();
            if (pp.isBit(fs) || (portPoly = ni.getShapeOfPort(pp)) == null) continue;
            portPoly.transform(trans);
            Color portColor = col;
            if (portColor == null) {
                portColor = pp.colorOfPort();
            }
            portGraphics.setColor(portColor);
            if (portDisplayLevel == 2) {
                this.drawCross(portPoly, portGraphics);
                continue;
            }
            if (!User.isTextVisibilityOnPort()) continue;
            TextDescriptor descript = portPoly.getTextDescriptor();
            Poly.Type type = descript.getPos().getPolyType();
            String portName = pp.getName();
            if (portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            Point pt = this.wnd.databaseToScreen(portPoly.getCenterX(), portPoly.getCenterY());
            Rectangle rect = new Rectangle(pt);
            this.drawText(rect, type, descript, portName, null, portGraphics);
        }
        fs.freeFlagSet();
    }

    private void drawUnexpandedCell(NodeInst ni, AffineTransform trans) {
        NodeProto np = ni.getProto();
        Poly poly = new Poly(ni.getTrueCenterX(), ni.getTrueCenterY(), ni.getXSize(), ni.getYSize());
        AffineTransform localPureTrans = ni.rotateOutAboutTrueCenter(trans);
        poly.transform(localPureTrans);
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            Point from = this.wnd.databaseToScreen(points[lastI]);
            Point to = this.wnd.databaseToScreen(points[i]);
            blackGraphics.setColor(new Color(User.getColorInstanceOutline()));
            this.drawLine(from, to, null, blackGraphics, 0);
        }
        if (User.isTextVisibilityOnInstance()) {
            Rectangle2D bounds = poly.getBounds2D();
            Rectangle rect = this.wnd.databaseToScreen(bounds);
            TextDescriptor descript = ni.getProtoTextDescriptor();
            blackGraphics.setColor(new Color(User.getColorText()));
            this.drawText(rect, Poly.Type.TEXTBOX, descript, np.describe(), null, blackGraphics);
        }
    }

    private void drawTinyLayers(Iterator layerIterator, int x, int y) {
        Iterator it = layerIterator;
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (layer == null) continue;
            int layerNum = -1;
            int col = 0;
            EGraphics graphics = layer.getGraphics();
            if (graphics != null) {
                int pat;
                int[] pattern;
                if (graphics.isPatternedOnDisplay() && (pattern = graphics.getPattern()) != null && ((pat = pattern[y & 0xF]) == 0 || (pat & 32768 >> (x & 0xF)) == 0)) continue;
                layerNum = graphics.getTransparentLayer() - 1;
                col = graphics.getColor().getRGB() & 0xFFFFFF;
            }
            if (layerNum >= this.numLayerBitMaps) continue;
            byte[][] layerBitMap = this.getLayerBitMap(layerNum);
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
                continue;
            }
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private boolean expandedCellCached(Cell subCell, AffineTransform subTrans, Rectangle2D bounds) {
        EditWindow renderedCell;
        if (expandedCells == null) {
            return false;
        }
        if (subCell.getView() == View.ICON) {
            return false;
        }
        String expandedName = this.makeExpandedName(subCell, subTrans);
        ExpandedCellInfo expandedCellCount = (ExpandedCellInfo)expandedCells.get(expandedName);
        if (expandedCellCount != null && expandedCellCount.instanceCount < 2) {
            return false;
        }
        Rectangle2D.Double cellBounds = new Rectangle2D.Double();
        ((Rectangle2D)cellBounds).setRect(subCell.getBounds());
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        Rectangle screenBounds = new Rectangle(this.wnd.databaseToScreen(poly.getBounds2D()));
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return true;
        }
        if (screenBounds.width >= PixelDrawing.topSz.width / 2 && screenBounds.height >= PixelDrawing.topSz.height / 2) {
            return false;
        }
        if (expandedCellCount == null) {
            expandedCellCount = new ExpandedCellInfo();
            expandedCellCount.instanceCount = 0;
            expandedCellCount.wnd = null;
            expandedCells.put(expandedName, expandedCellCount);
        }
        if ((renderedCell = expandedCellCount.wnd) == null) {
            expandedCellCount.wnd = renderedCell = EditWindow.CreateElectricDoc(subCell, null);
            renderedCell.setScreenSize(new Dimension(screenBounds.width, screenBounds.height));
            renderedCell.setScale(this.wnd.getScale());
            renderedCell.getOffscreen().clearImage(true);
            Point2D.Double cellCtr = new Point2D.Double(cellBounds.getCenterX(), cellBounds.getCenterY());
            subTrans.transform(cellCtr, cellCtr);
            renderedCell.setOffset(cellCtr);
            renderedCell.getOffscreen().renderedWindow = false;
            renderedCell.getOffscreen().drawCell(subCell, bounds, subTrans, false);
            ++offscreensCreated;
        }
        this.copyBits(renderedCell, screenBounds);
        ++offscreensUsed;
        return true;
    }

    private void countCell(Cell cell, AffineTransform prevTrans) {
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = (NodeInst)nodes.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            this.countNode(ni, prevTrans);
        }
    }

    private void countNode(NodeInst ni, AffineTransform trans) {
        NodeProto np = ni.getProto();
        Cell subCell = (Cell)np;
        double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
        if (halfWidth * this.wnd.getScale() < 1.0) {
            return;
        }
        Point2D ctr = ni.getTrueCenter();
        trans.transform(ctr, ctr);
        Rectangle2D databaseBounds = this.wnd.getDisplayedBounds();
        double ctrX = ctr.getX();
        double ctrY = ctr.getY();
        if (ctrX + halfWidth < databaseBounds.getMinX()) {
            return;
        }
        if (ctrX - halfWidth > databaseBounds.getMaxX()) {
            return;
        }
        if (ctrY + halfWidth < databaseBounds.getMinY()) {
            return;
        }
        if (ctrY - halfWidth > databaseBounds.getMaxY()) {
            return;
        }
        if (!ni.isExpanded()) {
            return;
        }
        AffineTransform localTrans = ni.rotateOut(trans);
        AffineTransform subTrans = ni.translateOut(localTrans);
        Rectangle2D cellBounds = subCell.getBounds();
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        Rectangle screenBounds = this.wnd.databaseToScreen(poly.getBounds2D());
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            String expandedName = this.makeExpandedName(subCell, subTrans);
            ExpandedCellInfo expansionCount = (ExpandedCellInfo)expandedCells.get(expandedName);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expandedName, expansionCount);
            } else {
                ++expansionCount.instanceCount;
                return;
            }
        }
        this.countCell(subCell, subTrans);
    }

    private String makeExpandedName(Cell subCell, AffineTransform subTrans) {
        int t00 = (int)(subTrans.getScaleX() * 100.0);
        int t01 = (int)(subTrans.getShearX() * 100.0);
        int t10 = (int)(subTrans.getShearY() * 100.0);
        int t11 = (int)(subTrans.getScaleY() * 100.0);
        String expandedName = subCell.describe() + " " + t00 + " " + t01 + " " + t10 + " " + t11;
        return expandedName;
    }

    private void copyBits(EditWindow renderedCell, Rectangle screenBounds) {
        PixelDrawing srcOffscreen = renderedCell.getOffscreen();
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        for (int srcY = 0; srcY < dim.height; ++srcY) {
            int destY = srcY + screenBounds.y;
            if (destY < 0 || destY >= this.sz.height) continue;
            int srcBase = srcY * dim.width;
            int destBase = destY * this.sz.width;
            for (int srcX = 0; srcX < dim.width; ++srcX) {
                int destX = srcX + screenBounds.x;
                if (destX < 0 || destX >= this.sz.width) continue;
                int srcColor = srcOffscreen.opaqueData[srcBase + srcX];
                if (srcColor != this.backgroundValue) {
                    this.opaqueData[destBase + destX] = srcColor;
                }
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] srcLayerBitMap = srcOffscreen.layerBitMaps[i];
                    if (srcLayerBitMap == null) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    byte[][] destLayerBitMap = this.getLayerBitMap(i);
                    byte[] destRow = destLayerBitMap[destY];
                    if ((srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
        Iterator it = srcOffscreen.patternedOpaqueLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            PatternedOpaqueLayer polSrc = (PatternedOpaqueLayer)srcOffscreen.patternedOpaqueLayers.get(layer);
            byte[][] srcLayerBitMap = polSrc.bitMap;
            if (srcLayerBitMap == null) continue;
            if (this.renderedWindow) {
                EGraphics desc = layer.getGraphics();
                int col = desc.getColor().getRGB() & 0xFFFFFF;
                int[] pattern = desc.getPattern();
                for (int srcY = 0; srcY < dim.height; ++srcY) {
                    int destY = srcY + screenBounds.y;
                    if (destY < 0 || destY >= this.sz.height) continue;
                    int destBase = destY * this.sz.width;
                    int pat = pattern[destY & 0xF];
                    if (pat == 0) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    for (int srcX = 0; srcX < dim.width; ++srcX) {
                        int destX = srcX + screenBounds.x;
                        if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0 || (pat & 32768 >> (destX & 0xF)) == 0) continue;
                        this.opaqueData[destBase + destX] = col;
                    }
                }
                continue;
            }
            PatternedOpaqueLayer polDest = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (polDest == null) {
                polDest = new PatternedOpaqueLayer();
                polDest.bitMap = new byte[this.sz.height][];
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    polDest.bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, polDest);
            }
            byte[][] destLayerBitMap = polDest.bitMap;
            for (int srcY = 0; srcY < dim.height; ++srcY) {
                int destY = srcY + screenBounds.y;
                if (destY < 0 || destY >= this.sz.height) continue;
                int destBase = destY * this.sz.width;
                byte[] srcRow = srcLayerBitMap[srcY];
                byte[] destRow = destLayerBitMap[destY];
                for (int srcX = 0; srcX < dim.width; ++srcX) {
                    int destX = srcX + screenBounds.x;
                    if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
    }

    private void drawPolys(Poly[] polys, AffineTransform trans) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            Layer layer = poly.getLayer();
            EGraphics graphics = null;
            if (layer != null) {
                if (!layer.isVisible()) continue;
                graphics = layer.getGraphics();
            }
            poly.transform(trans);
            this.renderPoly(poly, graphics);
            if (!this.periodicRefresh) continue;
            ++this.objectCount;
            if (this.objectCount <= 100) continue;
            this.objectCount = 0;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRefreshTime <= 1000L) continue;
            this.lastRefreshTime = currentTime;
            this.wnd.repaint();
        }
    }

    private byte[][] getLayerBitMap(int layerNum) {
        if (layerNum < 0) {
            return null;
        }
        Object layerBitMap = this.layerBitMaps[layerNum];
        if (layerBitMap == null) {
            layerBitMap = new byte[this.sz.height][];
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = new byte[this.numBytesPerRow];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
                layerBitMap[y] = row;
            }
            this.layerBitMaps[layerNum] = layerBitMap;
            ++this.numLayerBitMapsCreated;
        }
        return layerBitMap;
    }

    private void renderPoly(Poly poly, EGraphics graphics) {
        Point center;
        Point pt2;
        Rectangle2D bounds;
        int layerNum = -1;
        if (graphics != null) {
            layerNum = graphics.getTransparentLayer() - 1;
        }
        if (layerNum >= this.numLayerBitMaps) {
            return;
        }
        byte[][] layerBitMap = this.getLayerBitMap(layerNum);
        Poly.Type style = poly.getStyle();
        if (!this.renderedWindow && (style == Poly.Type.FILLED || style == Poly.Type.DISC) && layerBitMap == null && graphics.isPatternedOnDisplay()) {
            Layer layer = poly.getLayer();
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (pol == null) {
                pol = new PatternedOpaqueLayer();
                pol.bitMap = new byte[this.sz.height][];
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    pol.bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, pol);
            }
            layerBitMap = pol.bitMap;
            graphics = null;
        }
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            bounds = poly.getBox();
            if (bounds != null) {
                int lX = this.wnd.databaseToScreenX(bounds.getMinX());
                int hX = this.wnd.databaseToScreenX(bounds.getMaxX());
                int hY = this.wnd.databaseToScreenY(bounds.getMinY());
                int lY = this.wnd.databaseToScreenY(bounds.getMaxY());
                if (lX < 0) {
                    lX = 0;
                }
                if (hX >= this.sz.width) {
                    hX = this.sz.width - 1;
                }
                if (lY < 0) {
                    lY = 0;
                }
                if (hY >= this.sz.height) {
                    hY = this.sz.height - 1;
                }
                if (lX > hX || lY > hY) {
                    return;
                }
                this.drawBox(lX, hX, lY, hY, layerBitMap, graphics);
                return;
            }
            Point[] intPoints = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                intPoints[i] = this.wnd.databaseToScreen(points[i]);
            }
            Point[] clippedPoints = this.clipPoly(intPoints, 0, this.sz.width - 1, 0, this.sz.height - 1);
            this.drawPolygon(clippedPoints, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            Point pt0a = this.wnd.databaseToScreen(points[0]);
            Point pt1a = this.wnd.databaseToScreen(points[1]);
            Point pt2a = this.wnd.databaseToScreen(points[2]);
            Point pt3a = this.wnd.databaseToScreen(points[3]);
            Point pt0b = new Point(pt0a);
            Point pt0c = new Point(pt0a);
            Point pt1b = new Point(pt1a);
            Point pt1c = new Point(pt1a);
            Point pt2b = new Point(pt2a);
            Point pt2c = new Point(pt2a);
            Point pt3b = new Point(pt3a);
            Point pt3c = new Point(pt3a);
            this.drawLine(pt0a, pt1a, layerBitMap, graphics, 0);
            this.drawLine(pt1b, pt2a, layerBitMap, graphics, 0);
            this.drawLine(pt2b, pt3a, layerBitMap, graphics, 0);
            this.drawLine(pt3b, pt0b, layerBitMap, graphics, 0);
            this.drawLine(pt0c, pt2c, layerBitMap, graphics, 0);
            this.drawLine(pt1c, pt3c, layerBitMap, graphics, 0);
            return;
        }
        if (style.isText()) {
            bounds = poly.getBounds2D();
            Rectangle rect = this.wnd.databaseToScreen(bounds);
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            this.drawText(rect, style, descript, str, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point pt1 = this.wnd.databaseToScreen(points[j - 1]);
                Point pt22 = this.wnd.databaseToScreen(points[j]);
                this.drawLine(pt1, pt22, layerBitMap, graphics, lineType);
            }
            if (style == Poly.Type.CLOSED) {
                Point pt1 = this.wnd.databaseToScreen(points[points.length - 1]);
                pt2 = this.wnd.databaseToScreen(points[0]);
                this.drawLine(pt1, pt2, layerBitMap, graphics, lineType);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point pt1 = this.wnd.databaseToScreen(points[j]);
                pt2 = this.wnd.databaseToScreen(points[j + 1]);
                this.drawLine(pt1, pt2, layerBitMap, graphics, 0);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawCircle(center, edge, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawThickCircle(center, edge, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.DISC) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawDisc(center, edge, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge1 = this.wnd.databaseToScreen(points[1]);
            Point edge2 = this.wnd.databaseToScreen(points[2]);
            this.drawCircleArc(center, edge1, edge2, style == Poly.Type.THICKCIRCLEARC, layerBitMap, graphics);
            return;
        }
        if (style == Poly.Type.CROSS) {
            this.drawCross(poly, graphics);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            center = this.wnd.databaseToScreen(points[0]);
            int size = 5;
            this.drawLine(new Point(center.x - size, center.y), new Point(center.x + size, center.y), layerBitMap, graphics, 0);
            this.drawLine(new Point(center.x, center.y - size), new Point(center.x, center.y + size), layerBitMap, graphics, 0);
            return;
        }
    }

    private void drawBox(int lX, int hX, int lY, int hY, byte[][] layerBitMap, EGraphics desc) {
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        if (pattern == null) {
            if (layerBitMap == null) {
                for (int y = lY; y <= hY; ++y) {
                    int baseIndex = y * this.sz.width + lX;
                    for (int x = lX; x <= hX; ++x) {
                        this.opaqueData[baseIndex++] = col;
                    }
                }
            } else {
                for (int y = lY; y <= hY; ++y) {
                    byte[] row = layerBitMap[y];
                    for (int x = lX; x <= hX; ++x) {
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
            }
        } else if (layerBitMap == null) {
            for (int y = lY; y <= hY; ++y) {
                int pat = pattern[y & 0xF];
                if (pat == 0) continue;
                int baseIndex = y * this.sz.width;
                for (int x = lX; x <= hX; ++x) {
                    if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                    this.opaqueData[baseIndex + x] = col;
                }
            }
        } else {
            for (int y = lY; y <= hY; ++y) {
                int pat = pattern[y & 0xF];
                if (pat == 0) continue;
                byte[] row = layerBitMap[y];
                for (int x = lX; x <= hX; ++x) {
                    if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    private void drawLine(Point pt1, Point pt2, byte[][] layerBitMap, EGraphics desc, int texture) {
        if (this.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, 136);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, 231);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc);
            }
        }
    }

    private void drawCross(Poly poly, EGraphics graphics) {
        Point2D[] points = poly.getPoints();
        Point center = this.wnd.databaseToScreen(points[0]);
        int size = 3;
        this.drawLine(new Point(center.x - size, center.y), new Point(center.x + size, center.y), null, graphics, 0);
        this.drawLine(new Point(center.x, center.y - size), new Point(center.x, center.y + size), null, graphics, 0);
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc) {
        int dy;
        int dx;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        if ((dx = Math.abs(x2 - x1)) > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc, int pattern) {
        int dy;
        int col = 0;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
        }
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                i = i == 7 ? 0 : ++i;
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                i = i == 7 ? 0 : ++i;
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc) {
        int dy;
        int dx;
        int col = 0;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
        }
        if ((dx = Math.abs(x2 - x1)) > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        }
    }

    private void drawPolygon(Point[] points, byte[][] layerBitMap, EGraphics desc) {
        int i;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block1: for (i = 0; i < points.length; ++i) {
            int j;
            if (pattern != null && desc.isOutlinedOnDisplay()) {
                this.drawSolidLine(polySegs[i].fx, polySegs[i].fy, polySegs[i].tx, polySegs[i].ty, layerBitMap, desc);
            }
            polySegs[i].direction = (j = polySegs[i].ty - polySegs[i].fy) > 0 ? 1 : (j < 0 ? -1 : 0);
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block1;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block4: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block4;
                    }
                    a = a.nextactive;
                }
            }
            int wrap = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap += edge.direction) == 0) {
                    int x;
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    if (pattern != null) {
                        int pat = pattern[ycur & 0xF];
                        if (pat != 0) {
                            int x2;
                            if (layerBitMap == null) {
                                int baseIndex = ycur * this.sz.width;
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    this.opaqueData[baseIndex + x2] = col;
                                }
                            } else {
                                byte[] row = layerBitMap[ycur];
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int n = x2 >> 3;
                                    row[n] = (byte)(row[n] | 1 << (x2 & 7));
                                }
                            }
                        }
                    } else if (layerBitMap == null) {
                        int baseIndex = ycur * this.sz.width;
                        for (x = j; x <= k; ++x) {
                            this.opaqueData[baseIndex + x] = col;
                        }
                    } else {
                        byte[] row = layerBitMap[ycur];
                        for (x = j; x <= k; ++x) {
                            int n = x >> 3;
                            row[n] = (byte)(row[n] | 1 << (x & 7));
                        }
                    }
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
    }

    private void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, byte[][] layerBitMap, EGraphics desc) {
        Raster ras;
        int len = s.length();
        if (len == 0) {
            return;
        }
        int col = 0;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
        }
        int size = EditWindow.getDefaultFontSize();
        boolean fontStyle = false;
        String fontName = User.getDefaultFont();
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        if (descript != null) {
            TextDescriptor.ActiveFont af;
            size = descript.getTrueSize(this.wnd);
            if (size < 5) {
                return;
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = TextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
            rotation = descript.getRotation().getIndex();
        }
        int boxedWidth = -1;
        int boxedHeight = -1;
        if (style == Poly.Type.TEXTBOX) {
            boxedWidth = (int)rect.getWidth();
            boxedHeight = (int)rect.getHeight();
        }
        if ((ras = PixelDrawing.renderText(s, fontName, size, italic, bold, underline, boxedWidth, boxedHeight)) == null) {
            return;
        }
        Point pt = this.getTextCorner(ras, style, rect, rotation);
        int atX = pt.x;
        int atY = pt.y;
        DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
        byte[] samples = dbb.getData();
        int rasWidth = ras.getWidth();
        int rasHeight = ras.getHeight();
        switch (rotation) {
            case 0: {
                int sx = atX < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    int samp = y * rasWidth + sx;
                    for (int x = sx; x < ex; ++x) {
                        int alpha;
                        int trueX = atX + x;
                        if ((alpha = samples[samp++] & 0xFF) == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 1: {
                int sx = atX - rasHeight < 0 ? rasHeight - atX : 0;
                int ex = atX >= this.sz.height ? this.sz.height - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[x * rasWidth + (rasWidth - y - 1)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 2: {
                atY -= rasHeight;
                int sx = (atX -= rasWidth) < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(rasHeight - y - 1) * rasWidth + (rasWidth - x - 1)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 3: {
                int sx = atX - rasHeight < 0 ? rasHeight - atX : 0;
                int ex = atX >= this.sz.height ? this.sz.height - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(rasHeight - x - 1) * rasWidth + y] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
        }
    }

    private int alphaBlend(int color, int backgroundColor, int alpha) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int inverseAlpha = 254 - alpha;
        int redBack = backgroundColor >> 16 & 0xFF;
        int greenBack = backgroundColor >> 8 & 0xFF;
        int blueBack = backgroundColor & 0xFF;
        red = (red * alpha + redBack * inverseAlpha) / 255;
        green = (green * alpha + greenBack * inverseAlpha) / 255;
        blue = (blue * alpha + blueBack * inverseAlpha) / 255;
        color = red << 16 | (green << 8) + blue;
        return color;
    }

    private Point getTextCorner(Raster ras, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = ras.getWidth();
        int textHeight = ras.getHeight();
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    public static Raster renderText(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline, int boxedWidth, int boxedHeight) {
        double scale;
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find the proper font");
            return null;
        }
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = theFont.createGlyphVector(frc, msg);
        LineMetrics lm = theFont.getLineMetrics(msg, frc);
        Rectangle rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
        int width = rect.width;
        int height = (int)((double)lm.getHeight() + 0.5);
        if (width <= 0 || height <= 0) {
            return null;
        }
        if (boxedWidth > 0 && boxedHeight > 0 && (width > boxedWidth || height > boxedHeight) && (theFont = new Font(font, fontStyle, (int)((double)tSize * (scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height))))) != null) {
            gv = theFont.createGlyphVector(frc, msg);
            lm = theFont.getLineMetrics(msg, frc);
            rect = gv.getOutline(0.0f, lm.getAscent() - lm.getLeading()).getBounds();
            height = (int)((double)lm.getHeight() + 0.5);
            if (height <= 0) {
                return null;
            }
            width = rect.width;
        }
        if (underline) {
            ++height;
        }
        BufferedImage textImage = new BufferedImage(width, height, 10);
        Graphics2D g2 = (Graphics2D)textImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(new Color(255, 255, 255));
        g2.drawGlyphVector(gv, -rect.x, lm.getAscent() - lm.getLeading());
        if (underline) {
            g2.drawLine(0, height - 1, width, height - 1);
        }
        return textImage.getData();
    }

    private void drawCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc) {
        int x;
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                if (layerBitMap == null) {
                    int baseIndex = (center.y + y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y - y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y + x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                    baseIndex = (center.y - x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                } else {
                    byte[] row = layerBitMap[center.y + y];
                    int n = center.x + x >> 3;
                    row[n] = (byte)(row[n] | 1 << (center.x + x & 7));
                    int n2 = center.x - x >> 3;
                    row[n2] = (byte)(row[n2] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y - y];
                    int n3 = center.x + x >> 3;
                    row[n3] = (byte)(row[n3] | 1 << (center.x + x & 7));
                    int n4 = center.x - x >> 3;
                    row[n4] = (byte)(row[n4] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y + x];
                    int n5 = center.x + y >> 3;
                    row[n5] = (byte)(row[n5] | 1 << (center.x + y & 7));
                    int n6 = center.x - y >> 3;
                    row[n6] = (byte)(row[n6] | 1 << (center.x - y & 7));
                    row = layerBitMap[center.y - x];
                    int n7 = center.x + y >> 3;
                    row[n7] = (byte)(row[n7] | 1 << (center.x + y & 7));
                    int n8 = center.x - y >> 3;
                    row[n8] = (byte)(row[n8] | 1 << (center.x - y & 7));
                }
                if (d < 0) {
                    d += 4 * x + 6;
                    continue;
                }
                d += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if (d < 0) {
                    d += 4 * x + 6;
                } else {
                    d += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    private void drawThickCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc) {
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, byte[][] layerBitMap, int col, int[] pattern) {
        block12: {
            block11: {
                if (thisy < 0 || thisy >= this.sz.height) {
                    return;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (endx >= this.sz.width) {
                    endx = this.sz.width - 1;
                }
                if (pattern == null) break block11;
                int pat = pattern[thisy & 0xF];
                if (pat == 0) break block12;
                if (layerBitMap == null) {
                    int baseIndex = thisy * this.sz.width;
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                } else {
                    byte[] row = layerBitMap[thisy];
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
                break block12;
            }
            if (layerBitMap == null) {
                int baseIndex = thisy * this.sz.width;
                for (int x = startx; x <= endx; ++x) {
                    this.opaqueData[baseIndex + x] = col;
                }
            } else {
                byte[] row = layerBitMap[thisy];
                for (int x = startx; x <= endx; ++x) {
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    private void drawDisc(Point center, Point edge, byte[][] layerBitMap, EGraphics desc) {
        int radius = (int)center.distance(edge);
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = desc.getColor().getRGB() & 0xFFFFFF;
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
                if (desc.isOutlinedOnDisplay()) {
                    this.drawCircle(center, edge, layerBitMap, desc);
                }
            }
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    this.drawPoint(x, y, layerBitMap, col);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, layerBitMap, col, pattern);
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcLayerBitMap, this.arcCol);
        } else {
            this.drawPoint(x, y, this.arcLayerBitMap, this.arcCol);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void drawCircleArc(Point center, Point p1, Point p2, boolean thick, byte[][] layerBitMap, EGraphics desc) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcLayerBitMap = layerBitMap;
        this.arcCol = 0;
        if (desc != null) {
            this.arcCol = desc.getColor().getRGB() & 0xFFFFFF;
        }
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    private void drawPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawThickPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
            if (x > 0) {
                this.opaqueData[y * this.sz.width + (x - 1)] = col;
            }
            if (x < this.sz.width - 1) {
                this.opaqueData[y * this.sz.width + (x + 1)] = col;
            }
            if (y > 0) {
                this.opaqueData[(y - 1) * this.sz.width + (x + 1)] = col;
            }
            if (y < this.sz.height - 1) {
                this.opaqueData[(y + 1) * this.sz.width + (x + 1)] = col;
            }
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            if (x > 0) {
                byte[] byArray2 = layerBitMap[y];
                int n2 = x - 1 >> 3;
                byArray2[n2] = (byte)(byArray2[n2] | 1 << (x & 7));
            }
            if (x < this.sz.width - 1) {
                byte[] byArray3 = layerBitMap[y];
                int n3 = x + 1 >> 3;
                byArray3[n3] = (byte)(byArray3[n3] | 1 << (x & 7));
            }
            if (y > 0) {
                byte[] byArray4 = layerBitMap[y - 1];
                int n4 = x >> 3;
                byArray4[n4] = (byte)(byArray4[n4] | 1 << (x & 7));
            }
            if (y < this.sz.height - 1) {
                byte[] byArray5 = layerBitMap[y + 1];
                int n5 = x >> 3;
                byArray5[n5] = (byte)(byArray5[n5] | 1 << (x & 7));
            }
        }
    }

    private boolean clipLine(Point from, Point to, int lx, int hx, int ly, int hy) {
        while (true) {
            int t;
            int fc = 0;
            if (from.x < lx) {
                fc |= 1;
            } else if (from.x > hx) {
                fc |= 2;
            }
            if (from.y < ly) {
                fc |= 4;
            } else if (from.y > hy) {
                fc |= 8;
            }
            int tc = 0;
            if (to.x < lx) {
                tc |= 1;
            } else if (to.x > hx) {
                tc |= 2;
            }
            if (to.y < ly) {
                tc |= 4;
            } else if (to.y > hy) {
                tc |= 8;
            }
            if (fc == 0 && tc == 0) {
                return false;
            }
            if (fc == tc || (fc & tc) != 0) {
                return true;
            }
            if (fc == 0) {
                t = from.x;
                from.x = to.x;
                to.x = t;
                t = from.y;
                from.y = to.y;
                to.y = t;
                t = fc;
                fc = tc;
                tc = t;
            }
            if ((fc & 1) != 0) {
                if (to.x == from.x) {
                    return true;
                }
                t = (to.y - from.y) * (lx - from.x) / (to.x - from.x);
                from.y += t;
                from.x = lx;
            }
            if ((fc & 2) != 0) {
                if (to.x == from.x) {
                    return true;
                }
                t = (to.y - from.y) * (hx - from.x) / (to.x - from.x);
                from.y += t;
                from.x = hx;
            }
            if ((fc & 4) != 0) {
                if (to.y == from.y) {
                    return true;
                }
                t = (to.x - from.x) * (ly - from.y) / (to.y - from.y);
                from.x += t;
                from.y = ly;
            }
            if ((fc & 8) == 0) continue;
            if (to.y == from.y) {
                return true;
            }
            t = (to.x - from.x) * (hy - from.y) / (to.y - from.y);
            from.x += t;
            from.y = hy;
        }
    }

    private Point[] clipPoly(Point[] points, int lx, int hx, int ly, int hy) {
        Point[] swap;
        int count = points.length;
        int pre = 0;
        for (int i = 0; i < count; ++i) {
            if (points[i].x < lx) {
                pre |= 1;
            } else if (points[i].x > hx) {
                pre |= 2;
            }
            if (points[i].y < ly) {
                pre |= 4;
                continue;
            }
            if (points[i].y <= hy) continue;
            pre |= 8;
        }
        if (pre == 0) {
            return points;
        }
        Point[] in = new Point[count * 2];
        for (int i = 0; i < count * 2; ++i) {
            in[i] = new Point();
            if (i >= count) continue;
            in[i].setLocation(points[i]);
        }
        Point[] out = new Point[count * 2];
        for (int i = 0; i < count * 2; ++i) {
            out[i] = new Point();
        }
        Point[] a = in;
        Point[] b = out;
        if ((pre & 1) != 0) {
            count = this.clipEdge(a, count, b, 1, lx);
            swap = a;
            a = b;
            b = swap;
        }
        if ((pre & 2) != 0) {
            count = this.clipEdge(a, count, b, 2, hx);
            swap = a;
            a = b;
            b = swap;
        }
        if ((pre & 8) != 0) {
            count = this.clipEdge(a, count, b, 8, hy);
            swap = a;
            a = b;
            b = swap;
        }
        if ((pre & 4) != 0) {
            count = this.clipEdge(a, count, b, 4, ly);
            swap = a;
            a = b;
            b = swap;
        }
        pre = 0;
        for (int i = 0; i < count; ++i) {
            if (i > 0 && a[i - 1].x == a[i].x && a[i - 1].y == a[i].y) continue;
            b[pre].x = a[i].x;
            b[pre].y = a[i].y;
            ++pre;
        }
        while (pre != 0 && b[0].x == b[pre - 1].x && b[0].y == b[pre - 1].y) {
            --pre;
        }
        count = pre;
        Point[] retArr = new Point[count];
        for (int i = 0; i < count; ++i) {
            retArr[i] = b[i];
        }
        return retArr;
    }

    private int clipEdge(Point[] in, int inCount, Point[] out, int edge, int value) {
        Point first = new Point();
        Point second = new Point();
        int firstx = 0;
        int firsty = 0;
        int outcount = 0;
        for (int i = 0; i < inCount; ++i) {
            int pre = i - 1;
            if (i == 0) {
                pre = inCount - 1;
            }
            first.setLocation(in[pre]);
            second.setLocation(in[i]);
            if (this.clipSegment(first, second, edge, value)) continue;
            int x1 = first.x;
            int y1 = first.y;
            int x2 = second.x;
            int y2 = second.y;
            if (outcount != 0) {
                if (x1 != out[outcount - 1].x || y1 != out[outcount - 1].y) {
                    out[outcount].x = x1;
                    out[outcount++].y = y1;
                }
            } else {
                firstx = x1;
                firsty = y1;
            }
            out[outcount].x = x2;
            out[outcount++].y = y2;
        }
        if (outcount != 0 && (out[outcount - 1].x != firstx || out[outcount - 1].y != firsty)) {
            out[outcount].x = firstx;
            out[outcount++].y = firsty;
        }
        return outcount;
    }

    private boolean clipSegment(Point p1, Point p2, int codebit, int value) {
        int t;
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        int c1 = 0;
        int c2 = 0;
        if (codebit == 1) {
            if (x1 < value) {
                c1 = codebit;
            }
            if (x2 < value) {
                c2 = codebit;
            }
        } else if (codebit == 4) {
            if (y1 < value) {
                c1 = codebit;
            }
            if (y2 < value) {
                c2 = codebit;
            }
        } else if (codebit == 2) {
            if (x1 > value) {
                c1 = codebit;
            }
            if (x2 > value) {
                c2 = codebit;
            }
        } else if (codebit == 8) {
            if (y1 > value) {
                c1 = codebit;
            }
            if (y2 > value) {
                c2 = codebit;
            }
        }
        if (c1 == c2) {
            return c1 != 0;
        }
        boolean flip = false;
        if (c1 == 0) {
            t = x1;
            x1 = x2;
            x2 = t;
            t = y1;
            y1 = y2;
            y2 = t;
            flip = true;
        }
        if (codebit == 1 || codebit == 2) {
            t = (y2 - y1) * (value - x1) / (x2 - x1);
            y1 += t;
            x1 = value;
        } else if (codebit == 4 || codebit == 8) {
            t = (x2 - x1) * (value - y1) / (y2 - y1);
            x1 += t;
            y1 = value;
        }
        if (flip) {
            p1.x = x2;
            p1.y = y2;
            p2.x = x1;
            p2.y = y1;
        } else {
            p1.x = x1;
            p1.y = y1;
            p2.x = x2;
            p2.y = y2;
        }
        return false;
    }

    static {
        techWithLayers = null;
        expandedCells = null;
        noCellTextDescriptor = null;
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        blackGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, 1, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        portGraphics = new EGraphics(0, 0, 0, 255, 0, 0, 1.0, 1, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    private static class PatternedOpaqueLayer {
        byte[][] bitMap;
        byte[] compositeRow;

        private PatternedOpaqueLayer() {
        }
    }

    private static class ExpandedCellInfo {
        int instanceCount;
        EditWindow wnd;

        private ExpandedCellInfo() {
        }
    }

    private static class PolySeg {
        int fx;
        int fy;
        int tx;
        int ty;
        int direction;
        int increment;
        PolySeg nextedge;
        PolySeg nextactive;

        private PolySeg() {
        }
    }
}

