/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class FileMenu {
    protected static void addFileMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu fileMenu = new MenuBar.Menu("File", 'F');
        menuBar.add(fileMenu);
        fileMenu.addMenuItem("New Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.newLibraryCommand();
            }
        });
        fileMenu.addMenuItem("Open Library...", KeyStroke.getKeyStroke(79, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.openLibraryCommand();
            }
        });
        MenuBar.Menu importSubMenu = new MenuBar.Menu("Import");
        fileMenu.add(importSubMenu);
        importSubMenu.addMenuItem("Readable Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.importLibraryCommand();
            }
        });
        importSubMenu.addMenuItem("Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.readTextCell();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Close Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.closeLibraryCommand(Library.getCurrent());
            }
        });
        fileMenu.addMenuItem("Save Library", KeyStroke.getKeyStroke(83, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), OpenFile.Type.ELIB, false);
            }
        });
        fileMenu.addMenuItem("Save Library as...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveAsLibraryCommand();
            }
        });
        fileMenu.addMenuItem("Save All Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveAllLibrariesCommand();
            }
        });
        MenuBar.Menu exportSubMenu = new MenuBar.Menu("Export");
        fileMenu.add(exportSubMenu);
        exportSubMenu.addMenuItem("CIF (Caltech Intermediate Format)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.CIF, false);
            }
        });
        exportSubMenu.addMenuItem("GDS II (Stream)...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.GDS, false);
            }
        });
        exportSubMenu.addMenuItem("PostScript...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.exportCellCommand(OpenFile.Type.POSTSCRIPT, false);
            }
        });
        exportSubMenu.addMenuItem("Text Cell Contents...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextWindow.writeTextCell();
            }
        });
        exportSubMenu.addMenuItem("Readable Dump...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), OpenFile.Type.READABLEDUMP, false);
            }
        });
        exportSubMenu.addMenuItem("Version 6 ELIB...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.saveLibraryCommand(Library.getCurrent(), OpenFile.Type.ELIB, true);
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Change Current Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.changeCurrentLibraryCommand();
            }
        });
        fileMenu.addMenuItem("List Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.listLibrariesCommand();
            }
        });
        fileMenu.addMenuItem("Rename Library...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.renameLibraryCommand();
            }
        });
        fileMenu.addMenuItem("Mark All Libraries for Saving", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.markAllLibrariesForSavingCommand();
            }
        });
        fileMenu.addMenuItem("Repair Libraries", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.checkAndRepairCommand();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Print...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileMenu.printCommand();
            }
        });
        fileMenu.addSeparator();
        fileMenu.addMenuItem("Preferences...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.preferencesCommand();
            }
        });
        if (TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
            fileMenu.addMenuItem("Quit", KeyStroke.getKeyStroke(81, buckyBit), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileMenu.quitCommand();
                }
            });
        }
    }

    public static void newLibraryCommand() {
        String newLibName = JOptionPane.showInputDialog("New Library Name", (Object)"");
        if (newLibName == null) {
            return;
        }
        Library lib = Library.newInstance(newLibName, null);
        if (lib == null) {
            return;
        }
        lib.setCurrent();
        WindowFrame.wantToRedoLibraryTree();
        EditWindow.repaintAll();
        TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
    }

    public static void openLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.ELIB, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            ReadELIB readELIB = new ReadELIB(fileURL);
        }
    }

    private static boolean openALibrary(URL fileURL) {
        Library lib = Input.readLibrary(fileURL, OpenFile.Type.ELIB);
        Undo.noUndoAllowed();
        if (lib == null) {
            return false;
        }
        lib.setCurrent();
        Cell cell = lib.getCurCell();
        if (cell == null) {
            System.out.println("No current cell in this library");
        } else {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content.getCell() != null) continue;
                wf.setCellWindow(cell);
                WindowFrame.setCurrentWindowFrame(wf);
                TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
                return true;
            }
            WindowFrame.createEditWindow(cell);
            TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
        }
        return true;
    }

    public static void importLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.READABLEDUMP, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            ReadTextLibrary readTextLibrary = new ReadTextLibrary(fileURL);
        }
    }

    public static void closeLibraryCommand(Library lib) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to close library " + lib.getName() + "?");
        if (response != 0) {
            return;
        }
        String libName = lib.getName();
        WindowFrame.removeLibraryReferences(lib);
        if (lib.kill()) {
            System.out.println("Library " + libName + " closed");
        }
        WindowFrame.wantToRedoTitleNames();
        WindowFrame.wantToRedoLibraryTree();
        EditWindow.repaintAll();
        TopLevel.getCurrentJFrame().getToolBar().setEnabled("Save Library", Library.getCurrent() != null);
    }

    public static boolean saveLibraryCommand(Library lib, OpenFile.Type type, boolean compatibleWith6) {
        String fileName;
        String[] extensions = type.getExtensions();
        String extension = extensions[0];
        if (lib.isFromDisk() && type == OpenFile.Type.ELIB && !compatibleWith6) {
            fileName = lib.getLibFile().getPath();
        } else {
            fileName = OpenFile.chooseOutputFile(type, null, lib.getName() + "." + extension);
            if (fileName == null) {
                return false;
            }
            int dotPos = fileName.lastIndexOf(46);
            if (dotPos < 0) {
                fileName = fileName + "." + extension;
            } else if (!fileName.substring(dotPos + 1).equals(extension)) {
                fileName = fileName.substring(0, dotPos) + "." + extension;
            }
        }
        SaveLibrary job = new SaveLibrary(lib, fileName, type, compatibleWith6);
        return true;
    }

    public static void saveAsLibraryCommand() {
        Library lib = Library.getCurrent();
        lib.clearFromDisk();
        FileMenu.saveLibraryCommand(lib, OpenFile.Type.ELIB, false);
        WindowFrame.wantToRedoTitleNames();
    }

    public static void saveAllLibrariesCommand() {
        Library lib;
        Iterator it = Library.getLibraries();
        while (it.hasNext() && ((lib = (Library)it.next()).isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor() || FileMenu.saveLibraryCommand(lib, OpenFile.Type.ELIB, false))) {
        }
    }

    public static void exportCellCommand(OpenFile.Type type, boolean isNetlist) {
        if (type == OpenFile.Type.POSTSCRIPT && PostScript.syncAll()) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        VarContext context = wnd.getVarContext();
        String[] extensions = type.getExtensions();
        String filePath = cell.getName() + "." + extensions[0];
        if (type == OpenFile.Type.SPICE && !Simulation.getSpiceRunChoice().equals("Don't Run")) {
            filePath = Simulation.getSpiceUseRunDir() ? Simulation.getSpiceRunDir() + File.separator + filePath : User.getWorkingDirectory() + File.separator + filePath;
            if (User.isShowFileSelectionForNetlists() && !Simulation.getSpiceOutputOverwrite()) {
                String saveDir = User.getWorkingDirectory();
                filePath = OpenFile.chooseOutputFile(type, null, filePath);
                User.setWorkingDirectory(saveDir);
                if (filePath == null) {
                    return;
                }
            }
            FileMenu.exportCellCommand(cell, context, filePath, type);
            return;
        }
        if (User.isShowFileSelectionForNetlists() || !isNetlist) {
            if ((filePath = OpenFile.chooseOutputFile(type, null, filePath)) == null) {
                return;
            }
        } else {
            filePath = User.getWorkingDirectory() + File.separator + filePath;
        }
        FileMenu.exportCellCommand(cell, context, filePath, type);
    }

    public static void exportCellCommand(Cell cell, VarContext context, String filePath, OpenFile.Type type) {
        ExportCell job = new ExportCell(cell, context, filePath, type);
    }

    public static void printCommand() {
        Cell printCell = WindowFrame.needCurCell();
        if (printCell == null) {
            return;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName("Cell " + printCell.describe());
        ElectricPrinter ep = new ElectricPrinter();
        ep.setPrintCell(printCell);
        pj.setPrintable(ep);
        String pName = IOTool.getPrinterName();
        PrintService[] printers = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printerToUse = null;
        for (int i = 0; i < printers.length; ++i) {
            if (!pName.equals(printers[i].getName())) continue;
            printerToUse = printers[i];
            break;
        }
        if (printerToUse != null) {
            try {
                pj.setPrintService(printerToUse);
            }
            catch (PrinterException e) {
                System.out.println("Printing error " + e);
            }
        }
        if (pj.printDialog()) {
            printerToUse = pj.getPrintService();
            if (printerToUse != null) {
                IOTool.setPrinterName(printerToUse.getName());
            }
            PrintJob job = new PrintJob(printCell, pj);
        }
    }

    public static boolean quitCommand() {
        if (FileMenu.preventLoss(null, 0)) {
            return false;
        }
        QuitJob job = new QuitJob();
        return true;
    }

    public static boolean preventLoss(Library desiredLib, int action) {
        boolean saveCancelled = false;
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (desiredLib != null && desiredLib != lib || lib.isHidden() || !lib.isChangedMajor() && !lib.isChangedMinor()) continue;
            String how = "significantly";
            if (!lib.isChangedMajor()) {
                how = "insignificantly";
            }
            String theAction = "Save before quitting?";
            if (action == 1) {
                theAction = "Save before closing?";
            } else if (action == 2) {
                theAction = "Save before replacing?";
            }
            Object[] options = new String[]{"Yes", "No", "Cancel", "No to All"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Library " + lib.getName() + " has changed " + how + ".  " + theAction, "Save Library?", -1, 2, null, options, options[0]);
            if (ret == 0) {
                if (FileMenu.saveLibraryCommand(lib, OpenFile.Type.ELIB, false)) continue;
                saveCancelled = true;
                continue;
            }
            if (ret == 1) continue;
            if (ret == 2) {
                return true;
            }
            if (ret != 3) continue;
            break;
        }
        return saveCancelled;
    }

    private static class QuitJob
    extends Job {
        public QuitJob() {
            super("Quitting", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            System.exit(0);
            return true;
        }
    }

    private static class ElectricPrinter
    implements Printable {
        private Cell printCell;
        private Image img = null;

        private ElectricPrinter() {
        }

        public void setPrintCell(Cell printCell) {
            this.printCell = printCell;
        }

        public int print(Graphics g, PageFormat pageFormat, int page) throws PrinterException {
            if (page != 0) {
                return 1;
            }
            if (this.img == null) {
                EditWindow w = EditWindow.CreateElectricDoc(null, null);
                int iw = (int)pageFormat.getImageableWidth();
                int ih = (int)pageFormat.getImageableHeight();
                w.setScreenSize(new Dimension(iw, ih));
                w.setCell(this.printCell, VarContext.globalContext);
                PixelDrawing offscreen = w.getOffscreen();
                offscreen.setBackgroundColor(Color.WHITE);
                offscreen.drawImage(null);
                this.img = offscreen.getImage();
            }
            int ix = (int)pageFormat.getImageableX();
            int iy = (int)pageFormat.getImageableY();
            g.drawImage(this.img, ix, iy, null);
            return 0;
        }
    }

    private static class PrintJob
    extends Job {
        Cell cell;
        PrinterJob pj;

        public PrintJob(Cell cell, PrinterJob pj) {
            super("Print " + cell.describe(), User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.pj = pj;
            this.startJob();
        }

        public boolean doIt() {
            try {
                this.pj.print();
            }
            catch (PrinterException pe) {
                System.out.println("Print aborted.");
            }
            return true;
        }
    }

    private static class ExportCell
    extends Job {
        Cell cell;
        VarContext context;
        String filePath;
        OpenFile.Type type;

        public ExportCell(Cell cell, VarContext context, String filePath, OpenFile.Type type) {
            super("Export " + cell.describe() + " (" + type + ")", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.type = type;
            this.startJob();
        }

        public boolean doIt() {
            Output.writeCell(this.cell, this.context, this.filePath, this.type);
            return true;
        }
    }

    public static class SaveLibrary
    extends Job {
        Library lib;
        String newName;
        OpenFile.Type type;
        boolean compatibleWith6;

        public SaveLibrary(Library lib, String newName, OpenFile.Type type, boolean compatibleWith6) {
            super("Write Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.type = type;
            this.compatibleWith6 = compatibleWith6;
            this.startJob();
        }

        public boolean doIt() {
            boolean error;
            if (this.newName != null) {
                URL libURL = TextUtils.makeURLToFile(this.newName);
                this.lib.setLibFile(libURL);
                this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
            }
            if (error = Output.writeLibrary(this.lib, this.type, this.compatibleWith6)) {
                System.out.println("Error writing the library file");
            }
            return true;
        }
    }

    private static class ReadTextLibrary
    extends Job {
        URL fileURL;

        protected ReadTextLibrary(URL fileURL) {
            super("Read Text Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Input.readLibrary(this.fileURL, OpenFile.Type.READABLEDUMP);
            Undo.noUndoAllowed();
            if (lib == null) {
                return false;
            }
            lib.setCurrent();
            Cell cell = lib.getCurCell();
            if (cell == null) {
                System.out.println("No current cell in this library");
            } else {
                Iterator it = WindowFrame.getWindows();
                while (it.hasNext()) {
                    WindowFrame wf = (WindowFrame)it.next();
                    WindowContent content = wf.getContent();
                    if (!(content instanceof EditWindow) || content.getCell() != null) continue;
                    content.setCell(cell, VarContext.globalContext);
                    return true;
                }
                WindowFrame.createEditWindow(cell);
            }
            return true;
        }
    }

    public static class ReadInitialELIBs
    extends Job {
        List fileURLs;

        public ReadInitialELIBs(List fileURLs) {
            super("Read Initial Libraries", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURLs = fileURLs;
            this.startJob();
        }

        public boolean doIt() {
            Library mainLib = Library.newInstance("noname", null);
            if (mainLib == null) {
                return false;
            }
            mainLib.setCurrent();
            WindowFrame window1 = WindowFrame.createEditWindow(null);
            boolean success = false;
            Iterator it = this.fileURLs.iterator();
            while (it.hasNext()) {
                URL file = (URL)it.next();
                if (!FileMenu.openALibrary(file)) continue;
                success = true;
            }
            if (success) {
                mainLib.kill();
                WindowFrame.wantToRedoLibraryTree();
                EditWindow.repaintAll();
                EditWindow.repaintAllContents();
            }
            return true;
        }
    }

    public static class ReadELIB
    extends Job {
        URL fileURL;

        public ReadELIB(URL fileURL) {
            super("Read Library", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.startJob();
        }

        public boolean doIt() {
            return FileMenu.openALibrary(this.fileURL);
        }
    }
}

