/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NewCell
extends EDialog {
    private JList viewList;
    private DefaultListModel viewModel;
    private JButton cancel;
    private JTextField cellName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JComboBox library;
    private JCheckBox newWindow;
    private JButton ok;
    private JScrollPane view;

    public NewCell(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.viewModel = new DefaultListModel();
        this.viewList = new JList(this.viewModel);
        this.viewList.setSelectionMode(0);
        this.view.setViewportView(this.viewList);
        Iterator it = View.getViews();
        while (it.hasNext()) {
            View v = (View)it.next();
            this.viewModel.addElement(v.getFullName());
        }
        this.viewList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NewCell.this.ok(null);
                }
            }
        });
        Technology curTech = Technology.getCurrent();
        if (curTech == Schematics.tech) {
            this.viewList.setSelectedValue(View.SCHEMATIC.getFullName(), true);
        } else if (curTech == Artwork.tech) {
            this.viewList.setSelectedValue(View.ICON.getFullName(), true);
        } else {
            this.viewList.setSelectedValue(View.LAYOUT.getFullName(), true);
        }
        List libList = Library.getVisibleLibrariesSortedByName();
        Iterator it2 = libList.iterator();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            this.library.addItem(lib.getName());
        }
        int curIndex = libList.indexOf(Library.getCurrent());
        if (curIndex >= 0) {
            this.library.setSelectedIndex(curIndex);
        }
        this.cellName.grabFocus();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.cellName = new JTextField();
        this.jLabel4 = new JLabel();
        this.library = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.newWindow = new JCheckBox();
        this.view = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("New Cell");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewCell.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.cellName.setColumns(20);
        this.cellName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.cellNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cellName, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.library, gridBagConstraints);
        this.jLabel1.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("View:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.newWindow.setText("Make new window");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.newWindow, gridBagConstraints);
        this.view.setMinimumSize(new Dimension(200, 150));
        this.view.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.view, gridBagConstraints);
        this.pack();
    }

    private void cellNameActionPerformed(ActionEvent evt) {
        this.ok(evt);
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        String name = this.cellName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must type a cell name");
            return;
        }
        String viewName = (String)this.viewList.getSelectedValue();
        View v = View.findView(viewName);
        if (v != View.UNKNOWN) {
            name = name + "{" + v.getAbbreviation() + "}";
        }
        String libName = (String)this.library.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        boolean makeWindow = this.newWindow.isSelected();
        CreateCell job = new CreateCell(lib, name, makeWindow);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class CreateCell
    extends Job {
        Library lib;
        String cellName;
        boolean newWindow;

        protected CreateCell(Library lib, String cellName, boolean newWindow) {
            super("Create Cell " + cellName, User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.cellName = cellName;
            this.newWindow = newWindow;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = Cell.makeInstance(this.lib, this.cellName);
            if (cell == null) {
                System.out.println("Unable to create cell " + this.cellName);
                return false;
            }
            if (!this.newWindow) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                wf.setCellWindow(cell);
                WindowFrame.setCurrentWindowFrame(wf);
                return true;
            }
            WindowFrame.createEditWindow(cell);
            return true;
        }
    }
}

