/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SerialParallelMerge {
    private NccGlobals globals;

    private SerialParallelMerge(NccGlobals globals) {
        this.globals = globals;
    }

    private int processSerialMergeCandidates(List candidates) {
        int numMerged = 0;
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Wire w = (Wire)it.next();
            if (!Transistor.joinOnWire(w)) continue;
            ++numMerged;
        }
        return numMerged;
    }

    private void findSerialMergeCandidates(List candidates, Wire w) {
        if (w.numParts() == 2) {
            candidates.add(w);
        }
    }

    private boolean serialMerge() {
        ArrayList candidates = new ArrayList();
        EquivRecord wires = this.globals.getWires();
        Iterator it = wires.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            Iterator ni = ckt.getNetObjs();
            while (ni.hasNext()) {
                Wire w = (Wire)ni.next();
                this.findSerialMergeCandidates(candidates, w);
            }
        }
        int numMerged = this.processSerialMergeCandidates(candidates);
        this.globals.println("    Serial merged " + numMerged + " Parts");
        return numMerged > 0;
    }

    private int parallelMergeAllCandidatesInList(Collection parts) {
        Iterator it;
        int numMerged = 0;
        LinkedList pts = new LinkedList(parts);
        while ((it = pts.iterator()).hasNext()) {
            Part first = (Part)it.next();
            it.remove();
            while (it.hasNext()) {
                Part p = (Part)it.next();
                if (!first.parallelMerge(p)) continue;
                it.remove();
                ++numMerged;
            }
        }
        return numMerged;
    }

    private int parallelMergeEachListInMap(Map map) {
        int numMerged = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            ArrayList j = (ArrayList)map.get(it.next());
            numMerged += this.parallelMergeAllCandidatesInList(j);
        }
        return numMerged;
    }

    private int parallelMergePartsOnWire(Wire w) {
        HashMap<Integer, ArrayList<Part>> map = new HashMap<Integer, ArrayList<Part>>();
        Iterator wi = w.getParts();
        while (wi.hasNext()) {
            Part p = (Part)wi.next();
            Integer code = p.hashCodeForParallelMerge();
            ArrayList<Part> list = (ArrayList<Part>)map.get(code);
            if (list == null) {
                list = new ArrayList<Part>();
                map.put(code, list);
            }
            list.add(p);
        }
        return this.parallelMergeEachListInMap(map);
    }

    private boolean parallelMerge() {
        int numMerged = 0;
        EquivRecord er = this.globals.getWires();
        Iterator it = er.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            Iterator ni = ckt.getNetObjs();
            while (ni.hasNext()) {
                Wire w = (Wire)ni.next();
                numMerged += this.parallelMergePartsOnWire(w);
            }
        }
        this.globals.println("    Parallel merged " + numMerged + " Parts");
        return numMerged > 0;
    }

    private int countParts(EquivRecord parts) {
        int numParts = 0;
        Iterator it = parts.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            numParts += ckt.numNetObjs();
        }
        return numParts;
    }

    private void serialParallelMerge() {
        EquivRecord parts = this.globals.getParts();
        if (parts == null) {
            return;
        }
        int numParts = this.countParts(parts);
        this.globals.println("--- NCC starting merge process with " + numParts + " Parts");
        boolean first = true;
        int tripNumber = 1;
        while (true) {
            this.globals.println("  parallel and series merge trip " + tripNumber);
            boolean progress = this.parallelMerge();
            if (!first && !progress) break;
            first = false;
            progress = this.serialMerge();
            if (!progress) break;
            ++tripNumber;
        }
        numParts = this.countParts(parts);
        this.globals.println("--- NCC finishing merge process with " + numParts + " Parts");
        this.globals.println();
    }

    public static void doYourJob(NccGlobals globals) {
        SerialParallelMerge sp = new SerialParallelMerge(globals);
        sp.serialParallelMerge();
    }
}

