/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.AsciiUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class LocaleExtensions {
    public static final LocaleExtensions EMPTY_EXTENSIONS = new LocaleExtensions("");
    private String _extensions;
    private TreeMap _extMap;
    private TreeMap _kwdMap;
    private static final String LOCALEEXTSEP = "-";
    private static final String LDMLSINGLETON = "u";
    private static final String PRIVUSE = "x";
    private static final int MINLEN = 3;

    private LocaleExtensions(String extensions) {
        this._extensions = extensions == null ? "" : extensions;
    }

    public static LocaleExtensions getInstance(String extensions) {
        if (extensions == null || extensions.length() == 0) {
            return EMPTY_EXTENSIONS;
        }
        if ((extensions = Utility.replaceAll(AsciiUtil.toLowerString(extensions), "_", LOCALEEXTSEP)).length() < 3) {
            return new LocaleExtensions(extensions);
        }
        TreeMap<Character, String> extMap = null;
        TreeMap<String, String> kwdMap = null;
        boolean bParseFailure = false;
        String[] subtags = Utility.split(extensions, '-');
        String letter = null;
        extMap = new TreeMap<Character, String>();
        StringBuffer buf = new StringBuffer();
        boolean inLocaleKeywords = false;
        boolean inPrivateUse = false;
        String kwkey = null;
        int i = 0;
        while (i < subtags.length) {
            if (subtags[i].length() == 0) {
                bParseFailure = true;
                break;
            }
            if (subtags[i].length() == 1 && !inPrivateUse) {
                if (letter != null) {
                    if (extMap.containsKey(subtags[i])) {
                        bParseFailure = true;
                        break;
                    }
                    if (inLocaleKeywords) {
                        if (kwkey != null) {
                            bParseFailure = true;
                            break;
                        }
                        LocaleExtensions.keywordsToString(kwdMap, buf);
                        inLocaleKeywords = false;
                    }
                    if (buf.length() == 0) {
                        bParseFailure = true;
                        break;
                    }
                    extMap.put(new Character(letter.charAt(0)), buf.toString().intern());
                }
                if (subtags[i].equals(LDMLSINGLETON)) {
                    kwdMap = new TreeMap<String, String>();
                    inLocaleKeywords = true;
                } else if (subtags[i].equals(PRIVUSE)) {
                    inPrivateUse = true;
                }
                buf.setLength(0);
                letter = subtags[i];
            } else if (inLocaleKeywords) {
                if (kwkey == null) {
                    kwkey = subtags[i];
                } else {
                    kwdMap.put(kwkey.intern(), subtags[i].intern());
                    kwkey = null;
                }
            } else {
                if (buf.length() > 0) {
                    buf.append(LOCALEEXTSEP);
                }
                buf.append(subtags[i]);
            }
            ++i;
        }
        if (!bParseFailure) {
            if (inLocaleKeywords) {
                if (kwkey != null) {
                    bParseFailure = true;
                } else {
                    LocaleExtensions.keywordsToString(kwdMap, buf);
                }
            }
            if (buf.length() == 0) {
                bParseFailure = true;
            } else {
                extMap.put(new Character(letter.charAt(0)), buf.toString().intern());
            }
        }
        if (bParseFailure) {
            return new LocaleExtensions(extensions);
        }
        String canonical = LocaleExtensions.extensionsToCanonicalString(extMap);
        LocaleExtensions le = new LocaleExtensions(canonical);
        le._extMap = extMap;
        le._kwdMap = kwdMap;
        return le;
    }

    public static LocaleExtensions getInstance(TreeMap extMap, TreeMap kwdMap) {
        if (extMap == null) {
            return EMPTY_EXTENSIONS;
        }
        String canonical = LocaleExtensions.extensionsToCanonicalString(extMap);
        LocaleExtensions le = new LocaleExtensions(canonical);
        le._extMap = extMap;
        le._kwdMap = kwdMap;
        return le;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LocaleExtensions && this._extensions == ((LocaleExtensions)obj)._extensions;
    }

    public int hashCode() {
        return this._extensions.hashCode();
    }

    public Set getExtensionKeys() {
        if (this._extMap != null) {
            return Collections.unmodifiableSet(this._extMap.keySet());
        }
        return null;
    }

    public String getExtensionValue(char key) {
        if (this._extMap != null) {
            return (String)this._extMap.get(new Character(key));
        }
        return null;
    }

    public Set getLDMLKeywordKeys() {
        if (this._kwdMap != null) {
            return Collections.unmodifiableSet(this._kwdMap.keySet());
        }
        return null;
    }

    public String getLDMLKeywordType(String key) {
        if (key == null) {
            throw new NullPointerException("LDML key must not be null");
        }
        if (this._kwdMap != null) {
            return (String)this._kwdMap.get(key);
        }
        return null;
    }

    public String getCanonicalString() {
        return this._extensions;
    }

    public String toString() {
        return this._extensions;
    }

    private static String extensionsToCanonicalString(TreeMap extMap) {
        if (extMap == null || extMap.size() == 0) {
            return "";
        }
        StringBuffer canonicalbuf = new StringBuffer();
        String privUseStr = null;
        if (extMap != null) {
            Set entries = extMap.entrySet();
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Character key = (Character)entry.getKey();
                String value = (String)entry.getValue();
                if (key.charValue() == PRIVUSE.charAt(0)) {
                    privUseStr = value;
                    continue;
                }
                if (canonicalbuf.length() > 0) {
                    canonicalbuf.append(LOCALEEXTSEP);
                }
                canonicalbuf.append(key);
                canonicalbuf.append(LOCALEEXTSEP);
                canonicalbuf.append(value);
            }
        }
        if (privUseStr != null) {
            if (canonicalbuf.length() > 0) {
                canonicalbuf.append(LOCALEEXTSEP);
            }
            canonicalbuf.append(PRIVUSE);
            canonicalbuf.append(LOCALEEXTSEP);
            canonicalbuf.append(privUseStr);
        }
        return canonicalbuf.toString().intern();
    }

    public static void keywordsToString(TreeMap map, StringBuffer buf) {
        Set entries = map.entrySet();
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (buf.length() > 0) {
                buf.append(LOCALEEXTSEP);
            }
            buf.append(entry.getKey());
            buf.append(LOCALEEXTSEP);
            buf.append(entry.getValue());
        }
    }

    public static boolean isValidExtensionKey(char key) {
        return AsciiUtil.isAlphaNumeric(key);
    }

    public static boolean isValidLDMLKey(String key) {
        return key.length() == 2 && AsciiUtil.isAlphaNumericString(key);
    }

    public static boolean isValidLDMLType(String type) {
        return type.length() >= 3 && type.length() <= 8 && AsciiUtil.isAlphaNumericString(type);
    }
}

