/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.format.MonetaryAmountFormat;
import org.javamoney.moneta.format.MonetaryAmountDecimalFormat;
import org.javamoney.moneta.function.MonetaryAmountProducer;
import org.javamoney.moneta.function.MoneyProducer;

public class MonetaryAmountDecimalFormatBuilder {
    private DecimalFormat decimalFormat;
    private CurrencyUnit currencyUnit;
    private Locale locale;
    private MonetaryAmountProducer producer;

    private MonetaryAmountDecimalFormatBuilder() {
    }

    public static MonetaryAmountDecimalFormatBuilder newInstance() {
        MonetaryAmountDecimalFormatBuilder builder = new MonetaryAmountDecimalFormatBuilder();
        builder.decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
        return builder;
    }

    public static MonetaryAmountDecimalFormatBuilder of(Locale locale) {
        MonetaryAmountDecimalFormatBuilder builder = new MonetaryAmountDecimalFormatBuilder();
        builder.decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        builder.locale = locale;
        return builder;
    }

    public static MonetaryAmountDecimalFormatBuilder of(String pattern) {
        MonetaryAmountDecimalFormatBuilder builder = new MonetaryAmountDecimalFormatBuilder();
        builder.decimalFormat = new DecimalFormat(pattern);
        return builder;
    }

    public static MonetaryAmountDecimalFormatBuilder of(String pattern, Locale locale) {
        MonetaryAmountDecimalFormatBuilder builder = new MonetaryAmountDecimalFormatBuilder();
        builder.decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale));
        builder.locale = locale;
        return builder;
    }

    public MonetaryAmountDecimalFormatBuilder withCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
        return this;
    }

    public MonetaryAmountDecimalFormatBuilder withProducer(MonetaryAmountProducer producer) {
        this.producer = producer;
        return this;
    }

    public MonetaryAmountFormat build() {
        if (Objects.isNull(this.locale)) {
            this.locale = Locale.getDefault();
        }
        if (Objects.isNull(this.decimalFormat)) {
            this.decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(this.locale);
        }
        if (Objects.isNull(this.currencyUnit)) {
            this.currencyUnit = Monetary.getCurrency((Locale)this.locale, (String[])new String[0]);
        }
        if (Objects.isNull(this.producer)) {
            this.producer = new MoneyProducer();
        }
        this.decimalFormat.setCurrency(Currency.getInstance(this.currencyUnit.getCurrencyCode()));
        return new MonetaryAmountDecimalFormat(this.decimalFormat, this.producer, this.currencyUnit);
    }
}

