/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.Logger;
import java.security.AccessController;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.logback.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.logback.internal.spi.PaxLevelForLogback;
import org.osgi.framework.Bundle;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.spi.MDCAdapter;

public class PaxLoggerImpl
implements PaxLogger {
    private final Logger m_delegate;
    private final String m_fqcn;
    private final Bundle m_bundle;
    private final PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled(marker.slf4jMarker());
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled(marker.slf4jMarker());
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled(marker.slf4jMarker());
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isWarnEnabled(marker.slf4jMarker());
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.slf4jMarker());
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isErrorEnabled(marker.slf4jMarker());
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(null, 0, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(null, 10, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(null, 20, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(null, 30, 2, this.m_fqcn, message, t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(null, 40, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(null, 40, 1, this.m_fqcn, message, t);
        }
    }

    public void trace(String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled()) {
            this.doLog(null, 0, 4, fqcn, message, t);
        }
    }

    public void debug(String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled()) {
            this.doLog(null, 10, 4, fqcn, message, t);
        }
    }

    public void inform(String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled()) {
            this.doLog(null, 20, 3, fqcn, message, t);
        }
    }

    public void warn(String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled()) {
            this.doLog(null, 30, 2, fqcn, message, t);
        }
    }

    public void error(String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled()) {
            this.doLog(null, 40, 1, fqcn, message, t);
        }
    }

    public void fatal(String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled()) {
            this.doLog(null, 40, 1, fqcn, message, t);
        }
    }

    public void trace(PaxMarker marker, String message, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 0, 4, this.m_fqcn, message, t);
        }
    }

    public void debug(PaxMarker marker, String message, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 10, 4, this.m_fqcn, message, t);
        }
    }

    public void inform(PaxMarker marker, String message, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 20, 3, this.m_fqcn, message, t);
        }
    }

    public void warn(PaxMarker marker, String message, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 30, 2, this.m_fqcn, message, t);
        }
    }

    public void error(PaxMarker marker, String message, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, 1, this.m_fqcn, message, t);
        }
    }

    public void fatal(PaxMarker marker, String message, Throwable t) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, 1, this.m_fqcn, message, t);
        }
    }

    public void trace(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isTraceEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 0, 4, fqcn, message, t);
        }
    }

    public void debug(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isDebugEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 10, 4, fqcn, message, t);
        }
    }

    public void inform(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isInfoEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 20, 3, fqcn, message, t);
        }
    }

    public void warn(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isWarnEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 30, 2, fqcn, message, t);
        }
    }

    public void error(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isErrorEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, 1, fqcn, message, t);
        }
    }

    public void fatal(PaxMarker marker, String message, Throwable t, String fqcn) {
        if (this.isFatalEnabled(marker)) {
            this.doLog(marker.slf4jMarker(), 40, 1, fqcn, message, t);
        }
    }

    public int getLogLevel() {
        return new PaxLevelForLogback(this.m_delegate.getEffectiveLevel()).toInt();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Marker marker, int level, int svcLevel, String fqcn, String message, Throwable t) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(marker, level, svcLevel, fqcn, message, t);
                return null;
            });
        } else {
            this.doLog0(marker, level, svcLevel, fqcn, message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Marker marker, int level, int svcLevel, String fqcn, String message, Throwable t) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(marker, fqcn, level, message, null, t);
        }
        finally {
            this.clearDelegateContext();
        }
        this.m_service.handleEvents(this.m_bundle, null, svcLevel, message, t);
    }

    private void setDelegateContext() {
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.put("bundle.id", String.valueOf(this.m_bundle.getBundleId()));
            adapter.put("bundle.name", this.m_bundle.getSymbolicName());
            adapter.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        if (adapter != null) {
            adapter.remove(".log4j2_message");
        }
        this.m_service.lock(false);
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        MDCAdapter adapter = MDC.getMDCAdapter();
        if (this.m_bundle != null && adapter != null) {
            adapter.remove("bundle.id");
            adapter.remove("bundle.name");
            adapter.remove("bundle.version");
        }
    }
}

