/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.FactoryFinder;
import javax.xml.soap.Name;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public abstract class SOAPFactory {
    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract Detail createDetail() throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public static SOAPFactory newInstance() throws SOAPException {
        try {
            SOAPFactory factory = (SOAPFactory)FactoryFinder.find(SOAPFactory.class, null);
            if (factory == null) {
                factory = SOAPFactory.newInstance("SOAP 1.1 Protocol");
            }
            return factory;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create SOAPFactory: " + exception.getMessage());
        }
    }

    public static SOAPFactory newInstance(String protocol) throws SOAPException {
        return SAAJMetaFactory.getInstance().newSOAPFactory(protocol);
    }

    public SOAPElement createElement(Element element) throws SOAPException {
        return null;
    }

    public SOAPElement createElement(QName qname) throws SOAPException {
        return null;
    }

    public abstract SOAPFault createFault() throws SOAPException;

    public abstract SOAPFault createFault(String var1, QName var2) throws SOAPException;
}

