/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleSelectorImpl {
    private final BundleContext bundleContext;

    public BundleSelectorImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<Bundle> selectBundles(List<String> ids, boolean defaultAllBundles) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (ids != null && !ids.isEmpty()) {
            for (String id : ids) {
                if (id == null) continue;
                this.addMatchingBundles(id, bundles);
            }
        } else if (defaultAllBundles) {
            Collections.addAll(bundles, this.bundleContext.getBundles());
        }
        ArrayList<Bundle> filteredBundleList = new ArrayList<Bundle>(new LinkedHashSet(bundles));
        return filteredBundleList;
    }

    private void addMatchingBundles(String id, List<Bundle> bundles) {
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(id);
        if (matcher.matches()) {
            Bundle bundle = this.getBundleById(id);
            this.addBundle(bundle, id, bundles);
            return;
        }
        pattern = Pattern.compile("^(\\d+)-(\\d+)$");
        matcher = pattern.matcher(id);
        if (matcher.matches()) {
            long endId;
            int index = id.indexOf(45);
            long startId = Long.parseLong(id.substring(0, index));
            if (startId < (endId = Long.parseLong(id.substring(index + 1)))) {
                for (long i = startId; i <= endId; ++i) {
                    Bundle bundle = this.bundleContext.getBundle(i);
                    this.addBundle(bundle, String.valueOf(i), bundles);
                }
            }
            return;
        }
        int index = id.indexOf(47);
        List<Bundle> bundlesByName = index != -1 ? this.getBundleByNameAndVersion(id.substring(0, index), id.substring(index + 1)) : this.getBundleByName(id);
        for (Bundle bundleByName : bundlesByName) {
            this.addBundle(bundleByName, id, bundles);
        }
        List<Bundle> bundlesByLocation = this.getBundlesByLocation(id);
        for (Bundle bundleByLocation : bundlesByLocation) {
            this.addBundle(bundleByLocation, id, bundles);
        }
    }

    private void addBundle(Bundle bundle, String id, List<Bundle> bundles) {
        if (bundle == null) {
            System.err.println("Bundle " + id + " is invalid");
        } else {
            bundles.add(bundle);
        }
    }

    private Bundle getBundleById(String id) {
        Bundle bundle = null;
        try {
            long idNumber = Long.parseLong(id);
            bundle = this.bundleContext.getBundle(idNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bundle;
    }

    private List<Bundle> getBundleByName(String name) {
        return this.getBundleByNameAndVersion(name, null);
    }

    private List<Bundle> getBundleByNameAndVersion(String name, String version) {
        Bundle[] bundles = this.bundleContext.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Pattern namePattern = Pattern.compile(name);
        for (Bundle bundle : bundles) {
            boolean nameMatch;
            String bundleSymbolicName = bundle.getSymbolicName();
            if (bundleSymbolicName == null) continue;
            Matcher symbolicNameMatcher = namePattern.matcher(bundleSymbolicName);
            Matcher nameMatcher = null;
            String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
            if (bundleName != null) {
                nameMatcher = namePattern.matcher(bundleName);
            }
            if (version != null) {
                Pattern versionPattern;
                Matcher versionMatcher;
                boolean nameMatch2;
                String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
                if (bundleVersion == null) continue;
                boolean bl = nameMatch2 = nameMatcher != null && nameMatcher.matches() || symbolicNameMatcher.matches();
                if (!nameMatch2 || !(versionMatcher = (versionPattern = Pattern.compile(version)).matcher(bundleVersion)).matches()) continue;
                result.add(bundle);
                continue;
            }
            boolean bl = nameMatch = nameMatcher != null && nameMatcher.matches() || symbolicNameMatcher.matches();
            if (!nameMatch) continue;
            result.add(bundle);
        }
        return result;
    }

    private List<Bundle> getBundlesByLocation(String url) {
        Bundle[] bundles = this.bundleContext.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Pattern locationPattern = Pattern.compile(url);
        for (Bundle bundle : bundles) {
            Matcher locationMatcher = locationPattern.matcher(bundle.getLocation());
            if (!locationMatcher.matches()) continue;
            result.add(bundle);
        }
        return result;
    }
}

