/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentServerProxy;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.agent.unix.UnixAgentFactory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;

public class ProxyAgentFactory
implements SshAgentFactory {
    private final Map<String, AgentServerProxy> proxies = new ConcurrentHashMap<String, AgentServerProxy>();

    @Override
    public List<NamedFactory<Channel>> getChannelForwardingFactories(FactoryManager manager) {
        return ProxyAgentFactory.isPreferredUnixAgent(manager) ? UnixAgentFactory.DEFAULT_FORWARDING_CHANNELS : LocalAgentFactory.DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(FactoryManager manager) throws IOException {
        String proxyId = manager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(proxyId)) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy proxy = this.proxies.get(proxyId);
        if (proxy == null) {
            throw new IllegalStateException("No ssh agent found for ID=" + proxyId);
        }
        return proxy.createClient();
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Session session = service.getSession();
        ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", (Object)session);
        final AgentServerProxy proxy = new AgentServerProxy(service);
        this.proxies.put(proxy.getId(), proxy);
        return new SshAgentServer(){
            private final AtomicBoolean open = new AtomicBoolean(true);

            @Override
            public String getId() {
                return proxy.getId();
            }

            @Override
            public boolean isOpen() {
                return this.open.get() && proxy.isOpen();
            }

            @Override
            public void close() throws IOException {
                if (this.open.getAndSet(false)) {
                    ProxyAgentFactory.this.proxies.remove(proxy.getId());
                    proxy.close();
                }
            }
        };
    }

    public static boolean isPreferredUnixAgent(PropertyResolver resolver) {
        if (PropertyResolverUtils.getBooleanProperty(resolver, "ssh-prefer-unix-agent", OsUtils.isUNIX())) {
            try {
                if (AprLibrary.getInstance() != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

