/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;

public class ZipBundleEntry
extends BundleEntry {
    protected final ZipEntry zipEntry;
    protected final ZipBundleFile bundleFile;

    ZipBundleEntry(ZipEntry zipEntry, ZipBundleFile bundleFile) {
        this.zipEntry = zipEntry;
        this.bundleFile = bundleFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ZipBundleFile zipBundleFile = this.bundleFile;
        if (!zipBundleFile.isMruEnabled()) {
            return this.bundleFile.getZipFile().getInputStream(this.zipEntry);
        }
        zipBundleFile.incrementReference();
        ZipBundleEntryInputStream result = null;
        try {
            ZipBundleEntryInputStream zipBundleEntryInputStream = result = new ZipBundleEntryInputStream(zipBundleFile.getZipFile().getInputStream(this.zipEntry));
            return zipBundleEntryInputStream;
        }
        finally {
            if (result == null) {
                zipBundleFile.decrementReference();
            }
        }
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public String getName() {
        return this.zipEntry.getName();
    }

    @Override
    public long getTime() {
        return this.zipEntry.getTime();
    }

    @Override
    public URL getLocalURL() {
        try {
            return new URL("jar:" + this.bundleFile.basefile.toURL() + "!/" + this.zipEntry.getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.zipEntry.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private class ZipBundleEntryInputStream
    extends FilterInputStream {
        private boolean closed;

        public ZipBundleEntryInputStream(InputStream stream) {
            super(stream);
            this.closed = false;
        }

        @Override
        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                try {
                    super.close();
                }
                catch (IOException e) {
                    throw this.enrichExceptionWithBaseFile(e);
                }
            }
            catch (Throwable throwable) {
                ZipBundleEntryInputStream zipBundleEntryInputStream = this;
                synchronized (zipBundleEntryInputStream) {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                }
                ZipBundleEntry.this.bundleFile.decrementReference();
                throw throwable;
            }
            ZipBundleEntryInputStream zipBundleEntryInputStream = this;
            synchronized (zipBundleEntryInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            ZipBundleEntry.this.bundleFile.decrementReference();
        }

        @Override
        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0, int var1, int var2) throws IOException {
            try {
                return super.read(var0, var1, var2);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0) throws IOException {
            try {
                return super.read(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public long skip(long var0) throws IOException {
            try {
                return super.skip(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        private IOException enrichExceptionWithBaseFile(IOException e) {
            return new IOException(ZipBundleEntry.this.bundleFile.getBaseFile().toString(), e);
        }
    }
}

