/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.Set;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.hazelcast.HazelcastInstanceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellarMembershipListener
extends HazelcastInstanceAware
implements MembershipListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(CellarMembershipListener.class);
    private GroupManager groupManager;
    private List<? extends Synchronizer> synchronizers;

    public CellarMembershipListener(HazelcastInstance instance) {
        this.instance = instance;
        instance.getCluster().addMembershipListener((MembershipListener)this);
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        Member member = membershipEvent.getMember();
        try {
            Set groups;
            Member local = this.instance.getCluster().getLocalMember();
            if (local.equals(member) && this.synchronizers != null && !this.synchronizers.isEmpty() && (groups = this.groupManager.listLocalGroups()) != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    for (Synchronizer synchronizer : this.synchronizers) {
                        synchronizer.sync(group);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while calling memberAdded", (Throwable)e);
        }
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public List<? extends Synchronizer> getSynchronizers() {
        return this.synchronizers;
    }

    public void setSynchronizers(List<? extends Synchronizer> synchronizers) {
        this.synchronizers = synchronizers;
    }
}

