/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;

public final class SkipIterator
implements Iterator<Object>,
Closeable {
    private final CamelContext camelContext;
    private final Exchange exchange;
    private final Iterator<?> it;
    private final int skip;
    private boolean closed;
    private final AtomicBoolean hasSkip = new AtomicBoolean();

    public SkipIterator(Exchange exchange, Iterator<?> it, int skip) {
        this.exchange = exchange;
        this.camelContext = exchange.getContext();
        this.it = it;
        this.skip = skip;
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must not be a negative number, was: " + skip);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.it instanceof Scanner) {
                Scanner scanner = (Scanner)this.it;
                scanner.close();
                IOException ioException = scanner.ioException();
                if (ioException != null) {
                    throw ioException;
                }
            } else if (this.it instanceof Closeable) {
                IOHelper.closeWithException((Closeable)((Object)this.it));
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        boolean answer;
        if (this.closed) {
            return false;
        }
        if (this.hasSkip.compareAndSet(false, true)) {
            this.doSkip();
        }
        if (!(answer = this.it.hasNext())) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        if (this.hasSkip.compareAndSet(false, true)) {
            this.doSkip();
        }
        return this.it.next();
    }

    private void doSkip() {
        for (int i = 0; i < this.skip; ++i) {
            if (!this.it.hasNext()) continue;
            this.it.next();
        }
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

