/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchHeaderException
extends CamelExchangeException {
    private static final long serialVersionUID = -8721487431101572630L;
    private final String headerName;
    private final transient Class<?> type;

    public NoSuchHeaderException(Exchange exchange, String headerName, Class<?> type) {
        super("No '" + headerName + "' header available of type: " + type.getName() + NoSuchHeaderException.reason(exchange, headerName), exchange);
        this.headerName = headerName;
        this.type = type;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange, String propertyName) {
        Object value = exchange.getProperty(propertyName);
        return NoSuchHeaderException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has value: " + value + " of type: " + value.getClass().getCanonicalName();
    }
}

