/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.CloseableDirectory;
import org.apache.aries.util.filesystem.impl.FileImpl;

public class DirectoryImpl
extends FileImpl
implements IDirectory {
    public DirectoryImpl(File dir, File rootFile) {
        super(dir, rootFile);
    }

    @Override
    public IFile getFile(String name) {
        File desiredFile = new File(this.file, name);
        FileImpl result = null;
        if (desiredFile.exists()) {
            result = !desiredFile.isDirectory() ? new FileImpl(desiredFile, this.rootDirFile) : new DirectoryImpl(desiredFile, this.rootDirFile);
        }
        return result;
    }

    @Override
    public boolean isRoot() {
        boolean result = this.rootDirFile == this.file;
        return result;
    }

    @Override
    public List<IFile> listFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        File[] filesInDir = this.file.listFiles();
        if (filesInDir != null) {
            for (File f : filesInDir) {
                if (f.isFile()) {
                    files.add(new FileImpl(f, this.rootDirFile));
                    continue;
                }
                if (!f.isDirectory()) continue;
                files.add(new DirectoryImpl(f, this.rootDirFile));
            }
        }
        return files;
    }

    @Override
    public List<IFile> listAllFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        File[] filesInDir = this.file.listFiles();
        if (filesInDir != null) {
            for (File f : filesInDir) {
                if (f.isFile()) {
                    files.add(new FileImpl(f, this.rootDirFile));
                    continue;
                }
                if (!f.isDirectory()) continue;
                DirectoryImpl subdir = new DirectoryImpl(f, this.rootDirFile);
                files.add(subdir);
                files.addAll(subdir.listAllFiles());
            }
        }
        return files;
    }

    @Override
    public Iterator<IFile> iterator() {
        return this.listFiles().iterator();
    }

    @Override
    public IDirectory getParent() {
        return this.isRoot() ? null : super.getParent();
    }

    @Override
    public IDirectory convert() {
        return this;
    }

    @Override
    public InputStream open() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        long result = super.getLastModified();
        for (IFile aFile : this) {
            long tmpLastModified = aFile.getLastModified();
            if (tmpLastModified <= result) continue;
            result = tmpLastModified;
        }
        return result;
    }

    @Override
    public ICloseableDirectory toCloseable() {
        return new CloseableDirectory(this);
    }
}

