/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.Iterator;
import java.util.Map;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.command.completers.AvailableRepoNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="feature-repo-refresh", description="Refresh a features repository on the cluster")
@Service
public class RepoRefreshCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="name/url", description="Shortcut name of the features repository or the full URL", required=false, multiValued=false)
    @Completion(value=AvailableRepoNameCompleter.class)
    String nameOrUrl;
    @Reference
    private EventProducer eventProducer;
    @Reference
    private FeaturesService featuresService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            String uri = null;
            if (this.nameOrUrl != null) {
                Map clusterFeaturesRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + this.groupName);
                for (Map.Entry entry : clusterFeaturesRepositories.entrySet()) {
                    if (!((String)entry.getKey()).equals(this.nameOrUrl) && !((String)entry.getValue()).equals(this.nameOrUrl)) continue;
                    uri = (String)entry.getKey();
                    break;
                }
                if (uri == null) {
                    System.err.println("Features repository " + this.nameOrUrl + " doesn't exist in cluster group " + this.groupName);
                    Iterator iterator = null;
                    return iterator;
                }
            }
            ClusterRepositoryEvent event = new ClusterRepositoryEvent(uri, RepositoryEvent.EventType.RepositoryAdded);
            event.setRefresh(true);
            event.setSourceGroup(group);
            event.setSourceNode(this.clusterManager.getNode());
            this.eventProducer.produce((Event)event);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }
}

