/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.utils;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;

public class CombinedClassLoader
extends ClassLoader {
    private final ConcurrentMap<Long, Bundle> bundles = new ConcurrentHashMap<Long, Bundle>();
    private final ConcurrentMap<String, Bundle> classBundleCache = new ConcurrentHashMap<String, Bundle>();

    public void init() {
        this.bundles.clear();
        this.classBundleCache.clear();
    }

    public void destroy() {
        this.bundles.clear();
        this.classBundleCache.clear();
    }

    public void addBundle(Bundle bundle) {
        this.bundles.put(bundle.getBundleId(), bundle);
    }

    public void removeBundle(Bundle bundle) {
        this.bundles.remove(bundle.getBundleId());
        for (Map.Entry entry : this.classBundleCache.entrySet()) {
            if (((Bundle)entry.getValue()).getBundleId() != bundle.getBundleId()) continue;
            this.classBundleCache.remove(entry.getKey());
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Bundle bundle = (Bundle)this.classBundleCache.get(name);
        if (bundle != null) {
            Class<?> clazz = this.loadClassFromBundle(name, bundle);
            if (clazz != null) {
                return clazz;
            }
            this.classBundleCache.remove(name);
        }
        for (Map.Entry entry : this.bundles.entrySet()) {
            bundle = (Bundle)entry.getValue();
            Class<?> clazz = this.loadClassFromBundle(name, bundle);
            if (clazz == null) continue;
            this.classBundleCache.put(name, bundle);
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadClassFromBundle(String name, Bundle bundle) {
        try {
            if (bundle.getState() == 32 || bundle.getState() == 8) {
                return bundle.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (Map.Entry entry : this.bundles.entrySet()) {
            URL url;
            Bundle bundle = (Bundle)entry.getValue();
            if (bundle.getState() != 32 && bundle.getState() != 8 || (url = bundle.getResource(name)) == null) continue;
            return url;
        }
        return null;
    }
}

