/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public class DuplexConnectionPool
extends AbstractConnectionPool
implements Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(DuplexConnectionPool.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Deque<Connection> idleConnections;
    private final Set<Connection> activeConnections;

    public DuplexConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super(destination, maxConnections, requester);
        this.idleConnections = new ArrayDeque<Connection>(maxConnections);
        this.activeConnections = new HashSet<Connection>(maxConnections);
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    @ManagedAttribute(value="The number of idle connections", readonly=true)
    public int getIdleConnectionCount() {
        this.lock();
        try {
            int n = this.idleConnections.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @ManagedAttribute(value="The number of active connections", readonly=true)
    public int getActiveConnectionCount() {
        this.lock();
        try {
            int n = this.activeConnections.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public Queue<Connection> getIdleConnections() {
        return this.idleConnections;
    }

    public Collection<Connection> getActiveConnections() {
        return this.activeConnections;
    }

    @Override
    public boolean isActive(Connection connection) {
        this.lock();
        try {
            boolean bl = this.activeConnections.contains(connection);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected void onCreated(Connection connection) {
        this.lock();
        try {
            this.idleConnections.offer(connection);
        }
        finally {
            this.unlock();
        }
        this.idle(connection, false);
    }

    @Override
    protected Connection activate() {
        Connection connection;
        this.lock();
        try {
            connection = this.idleConnections.poll();
            if (connection == null) {
                Connection connection2 = null;
                return connection2;
            }
            this.activeConnections.add(connection);
        }
        finally {
            this.unlock();
        }
        return this.active(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(Connection connection) {
        boolean closed = this.isClosed();
        this.lock();
        try {
            if (!this.activeConnections.remove(connection)) {
                boolean bl = false;
                return bl;
            }
            if (!closed) {
                this.deactivate(connection);
            }
        }
        finally {
            this.unlock();
        }
        this.released(connection);
        return this.idle(connection, closed);
    }

    protected boolean deactivate(Connection connection) {
        return this.idleConnections.offerFirst(connection);
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Connection connection, boolean force) {
        boolean removed;
        boolean idleRemoved;
        boolean activeRemoved;
        this.lock();
        try {
            activeRemoved = this.activeConnections.remove(connection);
            idleRemoved = this.idleConnections.remove(connection);
        }
        finally {
            this.unlock();
        }
        if (activeRemoved || force) {
            this.released(connection);
        }
        boolean bl = removed = activeRemoved || idleRemoved || force;
        if (removed) {
            this.removed(connection);
        }
        return removed;
    }

    @Override
    public void close() {
        super.close();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        this.lock();
        try {
            connections.addAll(this.idleConnections);
            this.idleConnections.clear();
            connections.addAll(this.activeConnections);
            this.activeConnections.clear();
        }
        finally {
            this.unlock();
        }
        this.close(connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        DumpableCollection idle;
        DumpableCollection active;
        this.lock();
        try {
            active = new DumpableCollection("active", new ArrayList<Connection>(this.activeConnections));
            idle = new DumpableCollection("idle", new ArrayList<Connection>(this.idleConnections));
        }
        finally {
            this.unlock();
        }
        this.dump(out, indent, active, idle);
    }

    protected void dump(Appendable out, String indent, Object ... items) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])items);
    }

    public boolean sweep() {
        List toSweep;
        this.lock();
        try {
            toSweep = this.activeConnections.stream().filter(connection -> connection instanceof Sweeper.Sweepable).collect(Collectors.toList());
        }
        finally {
            this.unlock();
        }
        for (Connection connection2 : toSweep) {
            if (!((Sweeper.Sweepable)connection2).sweep()) continue;
            boolean removed = this.remove(connection2, true);
            LOG.warn("Connection swept: {}{}{} from active connections{}{}", new Object[]{connection2, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump()});
        }
        return false;
    }

    public String toString() {
        int idleSize;
        int activeSize;
        this.lock();
        try {
            activeSize = this.activeConnections.size();
            idleSize = this.idleConnections.size();
        }
        finally {
            this.unlock();
        }
        return String.format("%s@%x[c=%d/%d,a=%d,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getConnectionCount(), this.getMaxConnectionCount(), activeSize, idleSize);
    }
}

