/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.aries.transaction.internal.NLS;
import org.apache.aries.transaction.internal.TransactionManagerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ManagedService {
    public static final String PID = "org.apache.aries.transaction";
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.aries.transaction");
    private BundleContext bundleContext;
    private TransactionManagerService manager;
    private Dictionary properties;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Dictionary<String, Object> properties = this.getInitialConfig();
        this.updated(properties);
        bundleContext.registerService(ManagedService.class.getName(), (Object)this, this.getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getInitialConfig() {
        block5: {
            Dictionary dictionary;
            ConfigurationAdmin configurationAdmin;
            ServiceReference ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
            if (ref == null || (configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(ref)) == null) break block5;
            try {
                Configuration config = configurationAdmin.getConfiguration(PID);
                dictionary = config.getProperties();
            }
            catch (Throwable throwable) {
                try {
                    this.bundleContext.ungetService(ref);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.bundleContext.ungetService(ref);
            return dictionary;
        }
        return null;
    }

    private Dictionary<String, Object> getProps() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", PID);
        return props;
    }

    public void stop(BundleContext context) throws Exception {
        this.deleted();
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            properties = this.getProps();
        }
        if (!this.equals(this.properties, properties)) {
            this.deleted();
            this.properties = properties;
            this.manager = new TransactionManagerService(PID, properties, this.bundleContext);
            try {
                this.manager.start();
            }
            catch (Exception e) {
                log.error(NLS.MESSAGES.getMessage("exception.tx.manager.start", new Object[0]), (Throwable)e);
            }
        }
    }

    private boolean equals(Dictionary<String, Object> d1, Dictionary<String, Object> d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null ^ d2 == null) {
            return false;
        }
        if (d1.size() != d2.size()) {
            return false;
        }
        Enumeration<String> e1 = d1.keys();
        while (e1.hasMoreElements()) {
            Object v2;
            String key = e1.nextElement();
            Object v1 = d1.get(key);
            if (v1 == (v2 = d2.get(key)) || v2 != null && v2.equals(v1)) continue;
            return false;
        }
        return true;
    }

    public synchronized void deleted() {
        if (this.manager != null) {
            try {
                this.manager.close();
            }
            catch (Exception e) {
                log.error(NLS.MESSAGES.getMessage("exception.tx.manager.stop", new Object[0]), (Throwable)e);
            }
            finally {
                this.manager = null;
            }
        }
    }
}

