/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.cellar.core.CellarSupport;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;

public class ConfigurationSupport
extends CellarSupport {
    public static final String FELIX_FILEINSTALL_FILENAME = "felix.fileinstall.filename";
    public static final String KARAF_CELLAR_FILENAME = "karaf.cellar.filename";
    public static final String KARAF_CELLAR_CONTENT = "karaf.cellar.content";
    public static final String KARAF_CELLAR_REMOVED = "karaf.cellar.removed";
    protected File storage;

    public static Properties dictionaryToProperties(Dictionary dictionary) {
        Properties properties = new Properties();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (key == null || dictionary.get(key) == null) continue;
                properties.put(key, dictionary.get(key));
            }
        }
        return properties;
    }

    protected boolean equals(Dictionary source, Dictionary target) {
        if (source == null && target == null) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.isEmpty() && target.isEmpty()) {
            return true;
        }
        if (source.size() != target.size()) {
            return false;
        }
        Enumeration sourceKeys = source.keys();
        while (sourceKeys.hasMoreElements()) {
            Object key = sourceKeys.nextElement();
            if (key.equals("service.pid")) continue;
            Object sourceValue = source.get(key);
            Object targetValue = target.get(key);
            if (sourceValue != null && targetValue == null) {
                return false;
            }
            if (sourceValue == null && targetValue != null) {
                return false;
            }
            if (sourceValue.equals(targetValue)) continue;
            return false;
        }
        return true;
    }

    public boolean canDistributeConfig(Dictionary dictionary) {
        if (dictionary.get("service.factoryPid") != null) {
            return dictionary.get(KARAF_CELLAR_FILENAME) != null;
        }
        return true;
    }

    public boolean shouldReplicateConfig(Dictionary clusterDictionary) {
        return clusterDictionary.get(KARAF_CELLAR_REMOVED) == null;
    }

    public Dictionary filter(Dictionary dictionary) {
        Properties result = new Properties();
        if (dictionary != null) {
            Enumeration sourceKeys = dictionary.keys();
            while (sourceKeys.hasMoreElements()) {
                String value;
                String key = (String)sourceKeys.nextElement();
                if (key.equals(FELIX_FILEINSTALL_FILENAME)) {
                    value = dictionary.get(key).toString();
                    value = value.substring(value.lastIndexOf("/") + 1);
                    ((Dictionary)result).put(KARAF_CELLAR_FILENAME, value);
                    try {
                        ((Dictionary)result).put(KARAF_CELLAR_CONTENT, this.readFile(new File(this.storage, value)));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (this.isExcludedProperty(key)) continue;
                value = dictionary.get(key);
                ((Dictionary)result).put(key, value);
            }
        }
        return result;
    }

    public Properties getDeletedConfigurationMarker(Dictionary dictionary) {
        Properties result = new Properties();
        result.put("service.pid", dictionary.get("service.pid"));
        result.put(KARAF_CELLAR_FILENAME, dictionary.get(KARAF_CELLAR_FILENAME));
        result.put(KARAF_CELLAR_REMOVED, (Object)true);
        return result;
    }

    public Configuration findLocalConfiguration(String pid, Dictionary dictionary) throws IOException, InvalidSyntaxException {
        String filter;
        Object filename;
        Object object = filename = dictionary != null ? (Object)dictionary.get(KARAF_CELLAR_FILENAME) : null;
        if (filename != null) {
            String uri = new File(this.storage, filename.toString()).toURI().toString();
            filter = "(|(felix.fileinstall.filename=" + uri + ")(" + KARAF_CELLAR_FILENAME + "=" + dictionary.get(KARAF_CELLAR_FILENAME) + ")(" + "service.pid" + "=" + pid + "))";
        } else {
            filter = "(service.pid=" + pid + ")";
        }
        Configuration[] localConfigurations = this.configurationAdmin.listConfigurations(filter);
        return localConfigurations != null && localConfigurations.length > 0 ? localConfigurations[0] : null;
    }

    public Configuration createLocalConfiguration(String pid, Dictionary clusterDictionary) throws IOException {
        Object factoryPid = clusterDictionary.get("service.factoryPid");
        Configuration localConfiguration = factoryPid != null ? this.configurationAdmin.createFactoryConfiguration(factoryPid.toString(), null) : this.configurationAdmin.getConfiguration(pid, null);
        return localConfiguration;
    }

    public Dictionary convertPropertiesFromCluster(Dictionary dictionary) {
        Properties result = new Properties();
        if (dictionary != null) {
            Enumeration sourceKeys = dictionary.keys();
            while (sourceKeys.hasMoreElements()) {
                String value;
                String key = (String)sourceKeys.nextElement();
                if (key.equals(KARAF_CELLAR_FILENAME)) {
                    value = dictionary.get(key).toString();
                    ((Dictionary)result).put(FELIX_FILEINSTALL_FILENAME, new File(this.storage, value).toURI().toString());
                    continue;
                }
                if (key.equals(KARAF_CELLAR_CONTENT)) continue;
                value = dictionary.get(key);
                ((Dictionary)result).put(key, value);
            }
        }
        return result;
    }

    public boolean isExcludedProperty(String propertyName) {
        try {
            Dictionary properties;
            Configuration nodeConfiguration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (nodeConfiguration != null && (properties = nodeConfiguration.getProperties()) != null) {
                String property = properties.get("config.excluded.properties").toString();
                String[] excludedProperties = property.split(",");
                for (int i = 0; i < excludedProperties.length; ++i) {
                    if (!excludedProperties[i].trim().equals(propertyName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR CONFIG: can't check excluded properties", (Throwable)e);
        }
        return false;
    }

    protected void persistConfiguration(Configuration cfg, Dictionary clusterDictionary) {
        try {
            String content;
            File storageFile = this.getStorageFile(cfg.getProperties());
            if (storageFile == null && cfg.getProperties().get("service.factoryPid") != null) {
                storageFile = new File(this.storage, cfg.getPid() + ".cfg");
            }
            if (storageFile == null) {
                return;
            }
            String string = content = clusterDictionary == null ? null : (String)clusterDictionary.get(KARAF_CELLAR_CONTENT);
            if (content == null) {
                org.apache.felix.utils.properties.Properties p = new org.apache.felix.utils.properties.Properties(storageFile);
                ArrayList<String> propertiesToRemove = new ArrayList<String>();
                Set set = p.keySet();
                for (String key : set) {
                    if ("service.pid".equals(key) || "service.factoryPid".equals(key) || KARAF_CELLAR_FILENAME.equals(key) || FELIX_FILEINSTALL_FILENAME.equals(key)) continue;
                    propertiesToRemove.add(key);
                }
                for (String key : propertiesToRemove) {
                    p.remove(key);
                }
                Dictionary props = cfg.getProperties();
                Enumeration keys = props.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if ("service.pid".equals(key) || "service.factoryPid".equals(key) || KARAF_CELLAR_FILENAME.equals(key) || FELIX_FILEINSTALL_FILENAME.equals(key)) continue;
                    p.put(key, (String)props.get(key));
                }
                this.storage.mkdirs();
                p.save();
            } else {
                this.writeFile(storageFile, content);
            }
        }
        catch (Exception e) {
            LOGGER.error("CELLAR CONFIG: Issue when trying to persist configuration file", (Throwable)e);
        }
    }

    private File getStorageFile(Dictionary properties) throws IOException {
        File storageFile = null;
        Object val = properties.get(FELIX_FILEINSTALL_FILENAME);
        try {
            if (val instanceof URL) {
                storageFile = new File(((URL)val).toURI());
            }
            if (val instanceof URI) {
                storageFile = new File((URI)val);
            }
            if (val instanceof String) {
                storageFile = new File(new URL((String)val).toURI());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        return storageFile;
    }

    public String getKarafFilename(Dictionary dictionary) {
        return (String)this.filter(dictionary).get(KARAF_CELLAR_FILENAME);
    }

    protected void deleteConfiguration(Configuration localConfiguration) throws IOException {
        String filename = this.getKarafFilename(localConfiguration.getProperties());
        localConfiguration.delete();
        File cfgFile = new File(this.storage, filename == null ? localConfiguration.getPid() + ".cfg" : filename);
        if (cfgFile.exists()) {
            cfgFile.delete();
        }
    }

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }
}

