/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.coordinator.impl;

import java.util.Hashtable;
import org.apache.felix.coordinator.impl.CoordinationMgr;
import org.apache.felix.coordinator.impl.CoordinatorImpl;
import org.apache.felix.coordinator.impl.LogWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.coordinator.Coordinator;

public class Activator
implements BundleActivator {
    private CoordinationMgr mgr;
    private ServiceRegistration coordinatorService;

    public void start(BundleContext context) {
        LogWrapper.setContext(context);
        this.mgr = new CoordinationMgr();
        CoordinatorFactory factory = new CoordinatorFactory(this.mgr);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Coordinator Service Implementation");
        props.put("service.vendor", "The Apache Software Foundation");
        this.coordinatorService = context.registerService(Coordinator.class.getName(), (Object)factory, props);
    }

    public void stop(BundleContext context) {
        if (this.coordinatorService != null) {
            this.coordinatorService.unregister();
            this.coordinatorService = null;
        }
        this.mgr.cleanUp();
        LogWrapper.setContext(null);
    }

    static final class CoordinatorFactory
    implements ServiceFactory {
        private final CoordinationMgr mgr;

        CoordinatorFactory(CoordinationMgr mgr) {
            this.mgr = mgr;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return new CoordinatorImpl(bundle, this.mgr);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            ((CoordinatorImpl)service).dispose();
        }
    }
}

