/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.search;

import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.config.AtomicReferenceConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.CountDownLatchConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.dynamicconfig.search.ConfigSupplier;
import com.hazelcast.internal.dynamicconfig.search.DynamicFirstSearcher;
import com.hazelcast.internal.dynamicconfig.search.Searcher;
import com.hazelcast.internal.dynamicconfig.search.StaticFirstSearcher;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConfigSearch {
    private static final Map<Class, ConfigSupplier> CONFIG_SUPPLIERS = new ConcurrentHashMap<Class, ConfigSupplier>();

    private ConfigSearch() {
    }

    @Nullable
    public static <T extends IdentifiedDataSerializable> ConfigSupplier<T> supplierFor(@Nonnull Class<T> cls) {
        return CONFIG_SUPPLIERS.get(cls);
    }

    @Nonnull
    public static <T extends IdentifiedDataSerializable> Searcher<T> searcherFor(@Nonnull Config staticConfig, @Nonnull ConfigurationService configurationService, @Nonnull ConfigPatternMatcher configPatternMatcher, boolean isStaticFirst) {
        return isStaticFirst ? new StaticFirstSearcher(configurationService, staticConfig, configPatternMatcher) : new DynamicFirstSearcher(configurationService, staticConfig, configPatternMatcher);
    }

    static {
        CONFIG_SUPPLIERS.put(MapConfig.class, new ConfigSupplier<MapConfig>(){

            @Override
            public MapConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findMapConfig(name);
            }

            @Override
            public MapConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getMapConfig(name);
            }

            @Override
            public Map<String, MapConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getMapConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(CacheSimpleConfig.class, new ConfigSupplier<CacheSimpleConfig>(){

            @Override
            public CacheSimpleConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findCacheSimpleConfig(name);
            }

            @Override
            public CacheSimpleConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getCacheConfig(name);
            }

            @Override
            public Map<String, CacheSimpleConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getCacheConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(QueueConfig.class, new ConfigSupplier<QueueConfig>(){

            @Override
            public QueueConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findQueueConfig(name);
            }

            @Override
            public QueueConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getQueueConfig(name);
            }

            @Override
            public Map<String, QueueConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getQueueConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(LockConfig.class, new ConfigSupplier<LockConfig>(){

            @Override
            public LockConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findLockConfig(name);
            }

            @Override
            public LockConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getLockConfig(name);
            }

            @Override
            public Map<String, LockConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getLockConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(ListConfig.class, new ConfigSupplier<ListConfig>(){

            @Override
            public ListConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findListConfig(name);
            }

            @Override
            public ListConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getListConfig(name);
            }

            @Override
            public Map<String, ListConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getListConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(SetConfig.class, new ConfigSupplier<SetConfig>(){

            @Override
            public SetConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findSetConfig(name);
            }

            @Override
            public SetConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getSetConfig(name);
            }

            @Override
            public Map<String, SetConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getSetConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(MultiMapConfig.class, new ConfigSupplier<MultiMapConfig>(){

            @Override
            public MultiMapConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findMultiMapConfig(name);
            }

            @Override
            public MultiMapConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getMultiMapConfig(name);
            }

            @Override
            public Map<String, MultiMapConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getMultiMapConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(ReplicatedMapConfig.class, new ConfigSupplier<ReplicatedMapConfig>(){

            @Override
            public ReplicatedMapConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findReplicatedMapConfig(name);
            }

            @Override
            public ReplicatedMapConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getReplicatedMapConfig(name);
            }

            @Override
            public Map<String, ReplicatedMapConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getReplicatedMapConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(RingbufferConfig.class, new ConfigSupplier<RingbufferConfig>(){

            @Override
            public RingbufferConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findRingbufferConfig(name);
            }

            @Override
            public RingbufferConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getRingbufferConfig(name);
            }

            @Override
            public Map<String, RingbufferConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getRingbufferConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(AtomicLongConfig.class, new ConfigSupplier<AtomicLongConfig>(){

            @Override
            public AtomicLongConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findAtomicLongConfig(name);
            }

            @Override
            public AtomicLongConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getAtomicLongConfig(name);
            }

            @Override
            public Map<String, AtomicLongConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getAtomicLongConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(AtomicReferenceConfig.class, new ConfigSupplier<AtomicReferenceConfig>(){

            @Override
            public AtomicReferenceConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findAtomicReferenceConfig(name);
            }

            @Override
            public AtomicReferenceConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getAtomicReferenceConfig(name);
            }

            @Override
            public Map<String, AtomicReferenceConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getAtomicReferenceConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(CountDownLatchConfig.class, new ConfigSupplier<CountDownLatchConfig>(){

            @Override
            public CountDownLatchConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findCountDownLatchConfig(name);
            }

            @Override
            public CountDownLatchConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getCountDownLatchConfig(name);
            }

            @Override
            public Map<String, CountDownLatchConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getCountDownLatchConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(TopicConfig.class, new ConfigSupplier<TopicConfig>(){

            @Override
            public TopicConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findTopicConfig(name);
            }

            @Override
            public TopicConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getTopicConfig(name);
            }

            @Override
            public Map<String, TopicConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getTopicConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(ReliableTopicConfig.class, new ConfigSupplier<ReliableTopicConfig>(){

            @Override
            public ReliableTopicConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findReliableTopicConfig(name);
            }

            @Override
            public ReliableTopicConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getReliableTopicConfig(name);
            }

            @Override
            public Map<String, ReliableTopicConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getReliableTopicConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(ExecutorConfig.class, new ConfigSupplier<ExecutorConfig>(){

            @Override
            public ExecutorConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findExecutorConfig(name);
            }

            @Override
            public ExecutorConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getExecutorConfig(name);
            }

            @Override
            public Map<String, ExecutorConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getExecutorConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(DurableExecutorConfig.class, new ConfigSupplier<DurableExecutorConfig>(){

            @Override
            public DurableExecutorConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findDurableExecutorConfig(name);
            }

            @Override
            public DurableExecutorConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getDurableExecutorConfig(name);
            }

            @Override
            public Map<String, DurableExecutorConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getDurableExecutorConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(ScheduledExecutorConfig.class, new ConfigSupplier<ScheduledExecutorConfig>(){

            @Override
            public ScheduledExecutorConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findScheduledExecutorConfig(name);
            }

            @Override
            public ScheduledExecutorConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getScheduledExecutorConfig(name);
            }

            @Override
            public Map<String, ScheduledExecutorConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getScheduledExecutorConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(CardinalityEstimatorConfig.class, new ConfigSupplier<CardinalityEstimatorConfig>(){

            @Override
            public CardinalityEstimatorConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findCardinalityEstimatorConfig(name);
            }

            @Override
            public CardinalityEstimatorConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getCardinalityEstimatorConfig(name);
            }

            @Override
            public Map<String, CardinalityEstimatorConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getCardinalityEstimatorConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(SemaphoreConfig.class, new ConfigSupplier<SemaphoreConfig>(){

            @Override
            public SemaphoreConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findSemaphoreConfig(name);
            }

            @Override
            public SemaphoreConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getSemaphoreConfig(name);
            }

            @Override
            public Map<String, SemaphoreConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getSemaphoreConfigsAsMap();
            }
        });
        CONFIG_SUPPLIERS.put(FlakeIdGeneratorConfig.class, new ConfigSupplier<FlakeIdGeneratorConfig>(){

            @Override
            public FlakeIdGeneratorConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findFlakeIdGeneratorConfig(name);
            }

            @Override
            public FlakeIdGeneratorConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getFlakeIdGeneratorConfig(name);
            }

            @Override
            public Map<String, FlakeIdGeneratorConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getFlakeIdGeneratorConfigs();
            }
        });
        CONFIG_SUPPLIERS.put(PNCounterConfig.class, new ConfigSupplier<PNCounterConfig>(){

            @Override
            public PNCounterConfig getDynamicConfig(@Nonnull ConfigurationService configurationService, @Nonnull String name) {
                return configurationService.findPNCounterConfig(name);
            }

            @Override
            public PNCounterConfig getStaticConfig(@Nonnull Config staticConfig, @Nonnull String name) {
                return staticConfig.getPNCounterConfig(name);
            }

            @Override
            public Map<String, PNCounterConfig> getStaticConfigs(@Nonnull Config staticConfig) {
                return staticConfig.getPNCounterConfigs();
            }
        });
    }
}

