/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.util.Preconditions;

public class DiscoveryAddressProvider
implements AddressProvider {
    private final DiscoveryService discoveryService;

    public DiscoveryAddressProvider(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    public Addresses loadAddresses() {
        Iterable<DiscoveryNode> discoveredNodes = Preconditions.checkNotNull(this.discoveryService.discoverNodes(), "Discovered nodes cannot be null!");
        Addresses possibleMembers = new Addresses();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            possibleMembers.primary().add(discoveryNode.getPrivateAddress());
        }
        return possibleMembers;
    }
}

