/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.services.ProfileService;

public abstract class RouterAbstractRouteBuilder
extends RouteBuilder {
    protected JacksonDataFormat jacksonDataFormat;
    protected String kafkaHost;
    protected String kafkaPort;
    protected String kafkaImportTopic;
    protected String kafkaExportTopic;
    protected String kafkaImportGroupId;
    protected String kafkaExportGroupId;
    protected String kafkaConsumerCount;
    protected String kafkaAutoCommit;
    protected String configType;
    protected String allowedEndpoints;
    protected ProfileService profileService;

    public RouterAbstractRouteBuilder(Map<String, String> kafkaProps, String configType) {
        this.kafkaHost = kafkaProps.get("kafkaHost");
        this.kafkaPort = kafkaProps.get("kafkaPort");
        this.kafkaImportTopic = kafkaProps.get("kafkaImportTopic");
        this.kafkaExportTopic = kafkaProps.get("kafkaExportTopic");
        this.kafkaImportGroupId = kafkaProps.get("kafkaImportGroupId");
        this.kafkaExportGroupId = kafkaProps.get("kafkaExportGroupId");
        this.kafkaConsumerCount = kafkaProps.get("kafkaConsumerCount");
        this.kafkaAutoCommit = kafkaProps.get("kafkaAutoCommit");
        this.configType = configType;
    }

    public Object getEndpointURI(String direction, String operationDepositBuffer) {
        String endpoint;
        if ("kafka".equals(this.configType)) {
            String kafkaTopic = this.kafkaImportTopic;
            String kafkaGroupId = this.kafkaImportGroupId;
            if ("direct:depositExportBuffer".equals(operationDepositBuffer)) {
                kafkaTopic = this.kafkaExportTopic;
                kafkaGroupId = this.kafkaExportGroupId;
            }
            StringBuilder kafkaUri = new StringBuilder("kafka:");
            kafkaUri.append(this.kafkaHost).append(":").append(this.kafkaPort).append("?topic=").append(kafkaTopic);
            if (StringUtils.isNotBlank((CharSequence)kafkaGroupId)) {
                kafkaUri.append("&groupId=" + kafkaGroupId);
            }
            if ("to".equals(direction)) {
                kafkaUri.append("&autoCommitEnable=" + this.kafkaAutoCommit + "&consumersCount=" + this.kafkaConsumerCount);
            }
            KafkaConfiguration kafkaConfiguration = new KafkaConfiguration();
            kafkaConfiguration.setBrokers(this.kafkaHost + ":" + this.kafkaPort);
            kafkaConfiguration.setTopic(kafkaTopic);
            kafkaConfiguration.setGroupId(kafkaGroupId);
            endpoint = new KafkaEndpoint(kafkaUri.toString(), new KafkaComponent((CamelContext)this.getContext()));
            ((KafkaEndpoint)endpoint).setConfiguration(kafkaConfiguration);
        } else {
            endpoint = operationDepositBuffer;
        }
        return endpoint;
    }

    public void setJacksonDataFormat(JacksonDataFormat jacksonDataFormat) {
        this.jacksonDataFormat = jacksonDataFormat;
    }

    public void setAllowedEndpoints(String allowedEndpoints) {
        this.allowedEndpoints = allowedEndpoints;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }
}

