/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import javax.servlet.DispatcherType;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAnnotationScanner {
    public Boolean scanned = false;
    public String[] urlPatterns;
    public String filterName;
    public Integer loadOnStartup;
    public Boolean asyncSupported;
    public WebInitParam[] webInitParams;
    public MultipartConfig multiPartConfigAnnotation;
    public WebFilter filterAnnotation;
    public String[] servletNames;
    public DispatcherType[] dispatcherTypes;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FilterAnnotationScanner(Class<?> clazz) {
        this.filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (this.filterAnnotation == null) {
            return;
        }
        this.scanned = true;
        this.multiPartConfigAnnotation = clazz.getAnnotation(MultipartConfig.class);
        if (this.filterAnnotation.urlPatterns().length > 0 && this.filterAnnotation.value().length > 0) {
            this.log.warn(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns");
            return;
        }
        this.urlPatterns = this.filterAnnotation.value();
        if (this.urlPatterns.length == 0) {
            this.urlPatterns = this.filterAnnotation.urlPatterns();
        }
        this.filterName = this.filterAnnotation.filterName().equals("") ? clazz.getName() : this.filterAnnotation.filterName();
        this.webInitParams = this.filterAnnotation.initParams();
        this.servletNames = this.filterAnnotation.servletNames();
        this.dispatcherTypes = this.filterAnnotation.dispatcherTypes();
        this.asyncSupported = this.filterAnnotation.asyncSupported();
    }
}

