/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.Migration;
import org.apache.unomi.shell.migration.utils.ConsoleUtils;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class MigrationTo150
implements Migration {
    public static final String INDEX_DATE_PREFIX = "date-";

    @Override
    public Version getFromVersion() {
        return new Version("1.3.0");
    }

    @Override
    public Version getToVersion() {
        return new Version("1.5.0");
    }

    @Override
    public String getDescription() {
        return "Migrate the data from ElasticSearch 5.6 to 7.4";
    }

    @Override
    public void execute(Session session, CloseableHttpClient httpClient, String esAddress, BundleContext bundleContext) throws IOException {
        String es5Address = ConsoleUtils.askUserWithDefaultAnswer(session, "SOURCE Elasticsearch 5.6 cluster address (default: http://localhost:9210) : ", "http://localhost:9210");
        String sourceIndexPrefix = ConsoleUtils.askUserWithDefaultAnswer(session, "SOURCE index name (default: context) : ", "context");
        String destIndexPrefix = ConsoleUtils.askUserWithDefaultAnswer(session, "TARGET index prefix (default: context) : ", "context");
        int numberOfShards = Integer.parseInt(ConsoleUtils.askUserWithDefaultAnswer(session, "Number of shards for TARGET (default: 5) : ", "5"));
        int numberOfReplicas = Integer.parseInt(ConsoleUtils.askUserWithDefaultAnswer(session, "Number of replicas for TARGET (default: 1) : ", "1"));
        HashSet<String> monthlyIndexTypes = new HashSet<String>();
        monthlyIndexTypes.add("event");
        monthlyIndexTypes.add("session");
        long startTime = System.currentTimeMillis();
        JSONObject indicesStats = new JSONObject(HttpUtils.executeGetRequest(httpClient, es5Address + "/_stats", null));
        JSONObject indices = indicesStats.getJSONObject("indices");
        TreeSet indexNames = new TreeSet(indices.keySet());
        TreeSet<String> monthlyIndexNames = new TreeSet<String>();
        for (String indexName : indexNames) {
            if (!indexName.startsWith(sourceIndexPrefix + "-")) continue;
            monthlyIndexNames.add(indexName);
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            Enumeration predefinedMappings = bundle.findEntries("META-INF/cxs/mappings", "*.json", true);
            if (predefinedMappings == null) continue;
            while (predefinedMappings.hasMoreElements()) {
                String destIndexName;
                URL predefinedMappingURL = (URL)predefinedMappings.nextElement();
                String path = predefinedMappingURL.getPath();
                String itemType = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                String mappingDefinition = this.loadMappingFile(predefinedMappingURL);
                JSONObject newTypeMapping = new JSONObject(mappingDefinition);
                if (!monthlyIndexTypes.contains(itemType)) {
                    String indexName = "geonameEntry".equals(itemType) ? "geonames" : sourceIndexPrefix;
                    JSONObject es5TypeMapping = this.getES5TypeMapping(session, httpClient, es5Address, indexName, itemType);
                    int es5MappingsTotalFieldsLimit = this.getES5MappingsTotalFieldsLimit(httpClient, es5Address, indexName);
                    destIndexName = itemType.toLowerCase();
                    if (!this.indexExists(httpClient, esAddress, destIndexPrefix, destIndexName)) {
                        this.createESIndex(httpClient, esAddress, destIndexPrefix, destIndexName, numberOfShards, numberOfReplicas, es5MappingsTotalFieldsLimit, this.getMergedTypeMapping(es5TypeMapping, newTypeMapping));
                        this.reIndex(session, httpClient, esAddress, es5Address, indexName, this.getIndexName(destIndexPrefix, destIndexName), itemType);
                        continue;
                    }
                    ConsoleUtils.printMessage(session, "Index " + this.getIndexName(destIndexPrefix, itemType.toLowerCase()) + " already exists, skipping re-indexation...");
                    continue;
                }
                for (String indexName : monthlyIndexNames) {
                    String datePart = indexName.substring(sourceIndexPrefix.length() + 1);
                    destIndexName = itemType.toLowerCase() + "-" + INDEX_DATE_PREFIX + datePart;
                    JSONObject es5TypeMapping = this.getES5TypeMapping(session, httpClient, es5Address, indexName, itemType);
                    int es5MappingsTotalFieldsLimit = this.getES5MappingsTotalFieldsLimit(httpClient, es5Address, indexName);
                    if (!this.indexExists(httpClient, esAddress, destIndexPrefix, destIndexName)) {
                        this.createESIndex(httpClient, esAddress, destIndexPrefix, destIndexName, numberOfShards, numberOfReplicas, es5MappingsTotalFieldsLimit, this.getMergedTypeMapping(es5TypeMapping, newTypeMapping));
                        this.reIndex(session, httpClient, esAddress, es5Address, indexName, this.getIndexName(destIndexPrefix, destIndexName), itemType);
                        continue;
                    }
                    ConsoleUtils.printMessage(session, "Index " + this.getIndexName(destIndexPrefix, destIndexName) + " already exists, skipping re-indexation...");
                }
            }
        }
        long totalMigrationTime = System.currentTimeMillis() - startTime;
        ConsoleUtils.printMessage(session, "Migration operations completed in " + totalMigrationTime + "ms");
    }

    private String loadMappingFile(URL predefinedMappingURL) throws IOException {
        String l;
        BufferedReader reader = new BufferedReader(new InputStreamReader(predefinedMappingURL.openStream()));
        StringBuilder content = new StringBuilder();
        while ((l = reader.readLine()) != null) {
            content.append(l);
        }
        return content.toString();
    }

    private boolean indexExists(CloseableHttpClient httpClient, String esAddress, String indexPrefix, String indexName) {
        try {
            HttpUtils.executeHeadRequest(httpClient, esAddress + "/" + this.getIndexName(indexPrefix, indexName), null);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private String getIndexName(String indexPrefix, String indexName) {
        return indexPrefix + "-" + indexName;
    }

    private void createESIndex(CloseableHttpClient httpClient, String esAddress, String indexPrefix, String indexName, int numberOfShards, int numberOfReplicas, int mappingTotalFieldsLimit, JSONObject indexBody) throws IOException {
        indexBody.put("settings", (Object)new JSONObject().put("index", (Object)new JSONObject().put("number_of_shards", numberOfShards).put("number_of_replicas", numberOfReplicas).put("max_docvalue_fields_search", 1000)).put("analysis", (Object)new JSONObject().put("analyzer", (Object)new JSONObject().put("folding", (Object)new JSONObject().put("type", (Object)"custom").put("tokenizer", (Object)"keyword").put("filter", (Object)new JSONArray().put((Object)"lowercase").put((Object)"asciifolding"))))));
        if (mappingTotalFieldsLimit != -1) {
            indexBody.getJSONObject("settings").getJSONObject("index").put("mapping", (Object)new JSONObject().put("total_fields", (Object)new JSONObject().put("limit", mappingTotalFieldsLimit)));
        }
        HttpUtils.executePutRequest(httpClient, esAddress + "/" + this.getIndexName(indexPrefix, indexName), indexBody.toString(), null);
    }

    private void reIndex(Session session, CloseableHttpClient httpClient, String esAddress, String es5Address, String sourceIndexName, String destIndexName, String itemType) throws IOException {
        JSONObject reindexSettings = new JSONObject();
        reindexSettings.put("source", (Object)new JSONObject().put("remote", (Object)new JSONObject().put("host", (Object)es5Address)).put("index", (Object)sourceIndexName).put("type", (Object)itemType)).put("dest", (Object)new JSONObject().put("index", (Object)destIndexName));
        ConsoleUtils.printMessage(session, "Reindexing " + sourceIndexName + " to " + destIndexName + "...");
        long startTime = System.currentTimeMillis();
        try {
            String response = HttpUtils.executePostRequest(httpClient, esAddress + "/_reindex", reindexSettings.toString(), null);
            long reindexationTime = System.currentTimeMillis() - startTime;
            ConsoleUtils.printMessage(session, "Reindexing completed in " + reindexationTime + "ms. Result=" + response);
        }
        catch (IOException ioe) {
            ConsoleUtils.printException(session, "Error executing reindexing", ioe);
            ConsoleUtils.printMessage(session, "Attempting to delete index " + destIndexName + " so that we can restart from this point...");
            this.deleteIndex(session, httpClient, esAddress, destIndexName);
            throw ioe;
        }
    }

    private void deleteIndex(Session session, CloseableHttpClient httpClient, String esAddress, String indexName) {
        try {
            HttpUtils.executeDeleteRequest(httpClient, esAddress + "/" + indexName, null);
        }
        catch (IOException ioe) {
            ConsoleUtils.printException(session, "Error attempting to delete index" + indexName, ioe);
        }
    }

    private JSONObject getES5TypeMapping(Session session, CloseableHttpClient httpClient, String es5Address, String indexName, String typeName) throws IOException {
        String response = HttpUtils.executeGetRequest(httpClient, es5Address + "/" + indexName, null);
        if (response != null) {
            JSONObject indexInfo = new JSONObject(response).getJSONObject(indexName);
            JSONObject allTypeMappings = indexInfo.getJSONObject("mappings");
            if (allTypeMappings.has(typeName)) {
                return allTypeMappings.getJSONObject(typeName);
            }
            return new JSONObject();
        }
        return new JSONObject();
    }

    private int getES5MappingsTotalFieldsLimit(CloseableHttpClient httpClient, String es5Address, String indexName) throws IOException {
        JSONObject totalFieldsMappingIndexSettings;
        JSONObject mappingIndexSettings;
        JSONObject indexSettings;
        JSONObject indexInfo;
        JSONObject settings;
        String response = HttpUtils.executeGetRequest(httpClient, es5Address + "/" + indexName, null);
        if (response != null && (settings = (indexInfo = new JSONObject(response).getJSONObject(indexName)).getJSONObject("settings")).has("index") && (indexSettings = settings.getJSONObject("index")).has("mapping") && (mappingIndexSettings = indexSettings.getJSONObject("mapping")).has("total_fields") && (totalFieldsMappingIndexSettings = mappingIndexSettings.getJSONObject("total_fields")).has("limit")) {
            return totalFieldsMappingIndexSettings.getInt("limit");
        }
        return -1;
    }

    private JSONObject getMergedTypeMapping(JSONObject oldTypeMappings, JSONObject newTypeMappings) {
        JSONObject mappings = new JSONObject(oldTypeMappings.toString());
        if (newTypeMappings.has("dynamic_templates")) {
            mappings.put("dynamic_templates", (Object)newTypeMappings.getJSONArray("dynamic_templates"));
        }
        if (newTypeMappings.has("properties")) {
            mappings.put("properties", (Object)this.getMergedPropertyMappings(mappings.getJSONObject("properties"), newTypeMappings.getJSONObject("properties")));
        }
        return new JSONObject().put("mappings", (Object)mappings);
    }

    private JSONObject getMergedPropertyMappings(JSONObject oldProperties, JSONObject newProperties) {
        JSONObject result = new JSONObject();
        for (String oldPropertyName : oldProperties.keySet()) {
            if (!newProperties.has(oldPropertyName)) {
                result.put(oldPropertyName, oldProperties.get(oldPropertyName));
                continue;
            }
            JSONObject oldProperty = oldProperties.getJSONObject(oldPropertyName);
            JSONObject newProperty = newProperties.getJSONObject(oldPropertyName);
            if (oldProperty.has("properties") && newProperty.has("properties")) {
                JSONObject newObjectMapping = new JSONObject(newProperty.toString());
                newObjectMapping.put("properties", (Object)this.getMergedPropertyMappings(oldProperty.getJSONObject("properties"), newProperty.getJSONObject("properties")));
                result.put(oldPropertyName, (Object)newObjectMapping);
                continue;
            }
            result.put(oldPropertyName, newProperties.get(oldPropertyName));
        }
        for (String newPropertyName : newProperties.keySet()) {
            if (oldProperties.has(newPropertyName)) continue;
            result.putOnce(newPropertyName, newProperties.get(newPropertyName));
        }
        return result;
    }
}

