/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.metrics.commands;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.unomi.metrics.Metric;
import org.apache.unomi.metrics.commands.MetricsCommandSupport;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="metrics", name="view", description="This will display all the data for a single metric ")
public class ViewCommand
extends MetricsCommandSupport {
    @Argument(index=0, name="metricName", description="The identifier for the metric", required=true, multiValued=false)
    String metricName;

    protected Object doExecute() throws Exception {
        Metric metric = this.metricsService.getMetrics().get(this.metricName);
        if (metric == null) {
            System.out.println("Couldn't find a metric with name=" + this.metricName);
            return null;
        }
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter();
        defaultPrettyPrinter = defaultPrettyPrinter.withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        String jsonMetric = CustomObjectMapper.getObjectMapper().writer((PrettyPrinter)defaultPrettyPrinter).writeValueAsString((Object)metric);
        System.out.println(jsonMetric);
        return null;
    }
}

