/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditorManager;
import java.lang.reflect.Type;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.Primitives;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PropertyEditors {
    private static boolean registerWithVM;
    private static final PropertyEditorRegistry REGISTRY;

    public static boolean isRegisterWithVM() {
        return registerWithVM;
    }

    public static void setRegisterWithVM(boolean registerWithVM) {
        if (PropertyEditors.registerWithVM != registerWithVM) {
            PropertyEditors.registerWithVM = registerWithVM;
            if (registerWithVM) {
                for (Converter converter : REGISTRY.getRegistry().values()) {
                    PropertyEditorManager.registerEditor(converter.getType(), converter.getClass());
                }
            }
        }
    }

    public static void registerConverter(Converter converter) {
        REGISTRY.register(converter);
    }

    public static boolean canConvert(String type, ClassLoader classLoader) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            return REGISTRY.findConverter(Class.forName(type, true, classLoader)) != null;
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
    }

    public static boolean canConvert(Class<?> type) {
        return REGISTRY.findConverter(type) != null;
    }

    public static String toString(Object value) throws PropertyEditorException {
        return REGISTRY.toString(value);
    }

    public static Object getValue(String type, String value, ClassLoader classLoader) throws PropertyEditorException {
        return REGISTRY.getValue(type, value, classLoader);
    }

    public static Object getValue(Type type, String value) throws PropertyEditorException {
        return REGISTRY.getValue(type, value);
    }

    public static PropertyEditorRegistry registry() {
        return REGISTRY;
    }

    static {
        REGISTRY = new PropertyEditorRegistry(){
            {
                this.registerDefaults();
            }

            public Converter register(Converter converter) {
                Converter register = super.register(converter);
                if (registerWithVM) {
                    PropertyEditorManager.registerEditor(converter.getType(), converter.getClass());
                    Class<?> sibling = Primitives.findSibling(converter.getType());
                    if (sibling != null) {
                        PropertyEditorManager.registerEditor(sibling, converter.getClass());
                    }
                }
                return register;
            }
        };
    }
}

