/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.UnsupportedEncodingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class RequestEncodingSupport
extends TagSupport {
    static final String REQUEST_CHAR_SET = "javax.servlet.jsp.jstl.fmt.request.charset";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String value;
    protected String charEncoding;

    public RequestEncodingSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
    }

    @Override
    public int doEndTag() throws JspException {
        this.charEncoding = this.value;
        if (this.charEncoding == null && this.pageContext.getRequest().getCharacterEncoding() == null) {
            this.charEncoding = (String)this.pageContext.getAttribute(REQUEST_CHAR_SET, 3);
            if (this.charEncoding == null) {
                this.charEncoding = DEFAULT_ENCODING;
            }
        }
        if (this.charEncoding != null) {
            try {
                this.pageContext.getRequest().setCharacterEncoding(this.charEncoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new JspTagException(uee.toString(), uee);
            }
        }
        return 6;
    }

    @Override
    public void release() {
        this.init();
    }
}

