/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell;

import java.util.Map;
import java.util.Properties;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.config.shell.ConfigCommandSupport;
import org.apache.karaf.cellar.config.shell.completers.ClusterConfigCompleter;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="config-property-set", description="Set a property value for a configuration in a cluster group")
@Service
public class PropSetCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="pid", description="The configuration PID", required=true, multiValued=false)
    @Completion(value=ClusterConfigCompleter.class)
    String pid;
    @Argument(index=2, name="key", description="The property key", required=true, multiValued=false)
    String key;
    @Argument(index=3, name="value", description="The property value", required=true, multiValued=false)
    String value;
    @Reference
    private EventProducer eventProducer;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        if (!this.isAllowed(group, "config", this.pid, EventType.OUTBOUND)) {
            System.err.println("Configuration PID " + this.pid + " is blocked outbound for cluster group " + this.groupName);
            return null;
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + this.groupName);
        if (clusterConfigurations != null) {
            Properties properties = (Properties)clusterConfigurations.get(this.pid);
            if (properties == null) {
                properties = new Properties();
            }
            properties.put(this.key, this.value);
            clusterConfigurations.put(this.pid, properties);
            ClusterConfigurationEvent event = new ClusterConfigurationEvent(this.pid);
            event.setSourceGroup(group);
            event.setSourceNode(this.clusterManager.getNode());
            this.eventProducer.produce((Event)event);
        } else {
            System.out.println("No configuration found in cluster group " + this.groupName);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

