/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiName;

public abstract class ApiCollection<E extends Enum<E>, T> {
    private Map<E, ApiMethodHelper<? extends ApiMethod>> apiHelpers = Collections.emptyMap();
    private Map<Class<? extends ApiMethod>, E> apiMethods = Collections.emptyMap();
    private Set<String> apiNames = Collections.emptySet();

    public final Map<E, ApiMethodHelper<? extends ApiMethod>> getApiHelpers() {
        return this.apiHelpers;
    }

    public final Map<Class<? extends ApiMethod>, E> getApiMethods() {
        return this.apiMethods;
    }

    public final ApiMethodHelper<? extends ApiMethod> getHelper(E apiName) {
        return this.apiHelpers.get(apiName);
    }

    public final Set<String> getApiNames() {
        return this.apiNames;
    }

    public final E getApiName(Class<? extends ApiMethod> apiMethod) {
        return (E)((Enum)this.apiMethods.get(apiMethod));
    }

    public abstract T getEndpointConfiguration(E var1);

    protected final void setApiHelpers(Map<E, ApiMethodHelper<? extends ApiMethod>> apiHelpers) {
        this.apiHelpers = Collections.unmodifiableMap(apiHelpers);
        this.apiNames = Collections.unmodifiableSet(apiHelpers.keySet().stream().map(api -> ((ApiName)((Object)api)).getName()).collect(Collectors.toSet()));
    }

    protected final void setApiMethods(Map<Class<? extends ApiMethod>, E> apiMethods) {
        this.apiMethods = Collections.unmodifiableMap(apiMethods);
    }
}

