/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

public final class ExpressionToPredicateAdapter
implements Predicate {
    private final Expression expression;

    public ExpressionToPredicateAdapter(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(Exchange exchange) {
        if (this.expression instanceof Predicate) {
            return ((Predicate)((Object)this.expression)).matches(exchange);
        }
        Object value = this.expression.evaluate(exchange, Object.class);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    public String toString() {
        return this.expression.toString();
    }

    public static Predicate toPredicate(Expression expression) {
        return new ExpressionToPredicateAdapter(expression);
    }
}

