/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.runtimecatalog.DefaultRuntimeCamelCatalog;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointHelper.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong(0L);

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            ServiceHelper.startService(consumer);
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                ServiceHelper.stopAndShutdownService(consumer);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop PollingConsumer: " + consumer + ". This example is ignored.", (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(CamelContext context, String uri, String pattern) {
        if (context != null) {
            try {
                uri = context.resolvePropertyPlaceholders(uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, e);
            }
        }
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        if (uri.contains("://")) {
            String scheme = ObjectHelper.before(uri, "://");
            String path = ObjectHelper.after(uri, "://");
            if (EndpointHelper.matchPattern(scheme + ":" + path, pattern)) {
                return true;
            }
        } else {
            String scheme = ObjectHelper.before(uri, ":");
            String path = ObjectHelper.after(uri, ":");
            if (EndpointHelper.matchPattern(scheme + "://" + path, pattern)) {
                return true;
            }
        }
        return EndpointHelper.matchPattern(uri, pattern);
    }

    @Deprecated
    public static boolean matchEndpoint(String uri, String pattern) {
        return EndpointHelper.matchEndpoint(null, uri, pattern);
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equals(pattern)) {
            return true;
        }
        if (EndpointHelper.matchWildcard(name, pattern)) {
            return true;
        }
        return EndpointHelper.matchRegex(name, pattern);
    }

    private static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    private static boolean matchRegex(String name, String pattern) {
        try {
            if (name.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static void setProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        IntrospectionSupport.setProperties(context.getTypeConverter(), bean, parameters);
    }

    public static void setReferenceProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object v = entry.getValue();
            String value = v != null ? v.toString() : null;
            if (value == null || !EndpointHelper.isReferenceParameter(value) || !(hit = IntrospectionSupport.setProperty(context, context.getTypeConverter(), bean, name, null, value, true))) continue;
            it.remove();
        }
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        String valueNoHash = StringHelper.replaceAll(value, "#", "");
        if (mandatory) {
            return CamelContextHelper.mandatoryLookupAndConvert(context, valueNoHash, type);
        }
        return CamelContextHelper.lookupAndConvert(context, valueNoHash, type);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return new ArrayList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            ArrayList<T> singleElementList = new ArrayList<T>();
            singleElementList.add(elementType.cast(bean));
            return singleElementList;
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }

    public static <T> T resolveParameter(CamelContext context, String value, Class<T> type) {
        T result = EndpointHelper.isReferenceParameter(value) ? EndpointHelper.resolveReferenceParameter(context, value, type) : context.getTypeConverter().convertTo(type, value);
        return result;
    }

    @Deprecated
    public static <T> T resloveStringParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveParameter(context, value, type);
    }

    public static String getRouteIdFromEndpoint(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        List<Route> routes = endpoint.getCamelContext().getRoutes();
        for (Route route : routes) {
            if (!route.getEndpoint().equals(endpoint) && !route.getEndpoint().getEndpointKey().equals(endpoint.getEndpointKey())) continue;
            return route.getId();
        }
        return null;
    }

    public static String createEndpointId() {
        return "endpoint" + ENDPOINT_COUNTER.incrementAndGet();
    }

    public static String lookupEndpointRegistryId(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        Endpoint delegate = null;
        if (endpoint instanceof DelegateEndpoint) {
            delegate = ((DelegateEndpoint)endpoint).getEndpoint();
        }
        Map<String, Endpoint> map = endpoint.getCamelContext().getRegistry().findByTypeWithName(Endpoint.class);
        for (Map.Entry<String, Endpoint> entry : map.entrySet()) {
            if (!entry.getValue().equals(endpoint) && !entry.getValue().equals(delegate)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String browseRangeMessagesAsXml(BrowsableEndpoint endpoint, Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List<Exchange> exchanges = endpoint.getExchanges();
        if (exchanges.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<messages>");
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = exchanges.get(i);
            Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            String xml = MessageHelper.dumpAsXml(msg, includeBody);
            sb.append("\n").append(xml);
        }
        sb.append("\n</messages>");
        return sb.toString();
    }

    public static ExchangePattern resolveExchangePatternFromUrl(String url) throws URISyntaxException {
        Map<String, Object> parameters;
        String pattern;
        int idx = url.indexOf("?");
        if (idx > 0) {
            url = url.substring(idx + 1);
        }
        if ((pattern = (String)(parameters = URISupport.parseQuery(url, true)).get("exchangePattern")) != null) {
            return ExchangePattern.asEnum(pattern);
        }
        return null;
    }

    @Deprecated
    public static Map<String, Object> endpointProperties(CamelContext camelContext, String uri) throws Exception {
        DefaultRuntimeCamelCatalog catalog = new DefaultRuntimeCamelCatalog(camelContext, false);
        Map<String, String> options = catalog.endpointProperties(uri);
        return new HashMap<String, Object>(options);
    }
}

