/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.validator;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorValidator
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorValidator.class);
    private Processor processor;
    private String validatorString;

    public ProcessorValidator(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void validate(Message message, DataType type) throws ValidationException {
        Exchange exchange = message.getExchange();
        LOG.debug("Sending to validate processor '{}'", (Object)this.processor);
        DefaultExchange validateExchange = new DefaultExchange(exchange);
        validateExchange.setIn(message);
        validateExchange.setProperties(exchange.getProperties());
        try {
            this.processor.process(validateExchange);
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            throw new ValidationException(String.format("Validation failed for '%s'", type), validateExchange, e);
        }
    }

    public ProcessorValidator setProcessor(Processor processor) {
        this.processor = processor;
        this.validatorString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.validatorString == null) {
            this.validatorString = String.format("ProcessorValidator[type='%s', processor='%s']", this.getType(), this.processor);
        }
        return this.validatorString;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.processor, "processor", this);
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }
}

