/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class CipherPair {
    private final String transformation;
    private final Cipher enccipher;
    private final Cipher deccipher;

    public CipherPair(String transformation) throws GeneralSecurityException {
        this.transformation = transformation;
        int d = transformation.indexOf(47);
        String a = d > 0 ? transformation.substring(0, d) : transformation;
        KeyGenerator keygen = KeyGenerator.getInstance(a);
        keygen.init(new SecureRandom());
        SecretKey key = keygen.generateKey();
        this.enccipher = Cipher.getInstance(transformation);
        this.deccipher = Cipher.getInstance(transformation);
        this.enccipher.init(1, key);
        byte[] ivp = this.enccipher.getIV();
        this.deccipher.init(2, (Key)key, ivp == null ? null : new IvParameterSpec(ivp));
    }

    public String getTransformation() {
        return this.transformation;
    }

    public Cipher getEncryptor() {
        return this.enccipher;
    }

    public Cipher getDecryptor() {
        return this.deccipher;
    }
}

