/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;

public class RegistryBean
implements BeanHolder {
    private final CamelContext context;
    private final String name;
    private final Registry registry;
    private volatile BeanInfo beanInfo;
    private volatile Class<?> clazz;
    private ParameterMappingStrategy parameterMappingStrategy;

    public RegistryBean(CamelContext context, String name) {
        this(context.getRegistry(), context, name);
    }

    public RegistryBean(Registry registry, CamelContext context, String name) {
        this.registry = registry;
        this.context = context;
        this.name = name != null ? (name.startsWith("ref:") ? name.substring(4) : (name.startsWith("bean:") ? name.substring(5) : name)) : null;
    }

    public String toString() {
        return "bean: " + this.name;
    }

    public ConstantBeanHolder createCacheHolder() {
        Object bean = this.getBean();
        BeanInfo info = this.createBeanInfo(bean);
        return new ConstantBeanHolder(bean, info);
    }

    @Override
    public Object getBean() throws NoSuchBeanException {
        Object value = this.lookupBean();
        if (value != null) {
            if (value instanceof Class) {
                value = this.context.getInjector().newInstance((Class)value);
            }
            return value;
        }
        if (this.clazz == null) {
            this.clazz = this.context.getClassResolver().resolveClass(this.name);
        }
        if (this.clazz == null) {
            throw new NoSuchBeanException(this.name);
        }
        return this.context.getInjector().newInstance(this.clazz);
    }

    @Override
    public Processor getProcessor() {
        return null;
    }

    @Override
    public boolean supportProcessor() {
        return false;
    }

    @Override
    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            Object bean = this.getBean();
            this.beanInfo = this.createBeanInfo(bean);
        }
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return this.createBeanInfo(bean);
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public ParameterMappingStrategy getParameterMappingStrategy() {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = this.createParameterMappingStrategy();
        }
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    protected BeanInfo createBeanInfo(Object bean) {
        return new BeanInfo(this.context, bean.getClass(), this.getParameterMappingStrategy());
    }

    protected ParameterMappingStrategy createParameterMappingStrategy() {
        return BeanInfo.createParameterMappingStrategy(this.context);
    }

    protected Object lookupBean() {
        return this.registry.lookupByName(this.name);
    }
}

