/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;

public class MethodNotFoundException
extends CamelExchangeException {
    private static final long serialVersionUID = -7411465307141051012L;
    private final Object bean;
    private final String methodName;

    public MethodNotFoundException(Exchange exchange, Object pojo, String methodName) {
        super("Method with name: " + methodName + " not found on bean: " + pojo + " of type: " + ObjectHelper.className(pojo), exchange);
        this.methodName = methodName;
        this.bean = pojo;
    }

    public MethodNotFoundException(Exchange exchange, Object pojo, String methodName, String postfix) {
        super("Method with name: " + methodName + " " + postfix + " not found on bean: " + pojo + " of type: " + ObjectHelper.className(pojo), exchange);
        this.methodName = methodName;
        this.bean = pojo;
    }

    public MethodNotFoundException(Exchange exchange, Class<?> type, String methodName, boolean isStaticMethod) {
        super((isStaticMethod ? "Static method" : "Method") + " with name: " + methodName + " not found on class: " + ObjectHelper.name(type), exchange);
        this.methodName = methodName;
        this.bean = null;
    }

    public MethodNotFoundException(Object pojo, String methodName, Throwable cause) {
        super("Method with name: " + methodName + " not found on bean: " + pojo + " of type:" + ObjectHelper.className(pojo), null, cause);
        this.methodName = methodName;
        this.bean = pojo;
    }

    public MethodNotFoundException(Class<?> type, String methodName, Throwable cause) {
        super("Method with name: " + methodName + " not found on class: " + ObjectHelper.className(type), null, cause);
        this.methodName = methodName;
        this.bean = null;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getBean() {
        return this.bean;
    }
}

