/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.jbosslogging;

import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.Activator;
import org.ops4j.pax.logging.jbosslogging.JBossLoggingLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class PaxLoggingLoggerProvider
implements LoggerProvider {
    private static PaxLoggingManager paxLogging;
    private static PaxContext m_defaultContext;
    private static PaxContext m_context;

    public static void setPaxLoggingManager(PaxLoggingManager manager) {
        paxLogging = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getLogger(String name) {
        PaxLogger paxLogger = paxLogging == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Logger.class), name) : paxLogging.getLogger(name, JBossLoggingLogger.JBOSS_LOGGING_FQCN);
        JBossLoggingLogger logger = new JBossLoggingLogger(name, paxLogger);
        if (paxLogging == null) {
            List<PaxLoggingManagerAwareLogger> list = Activator.m_loggers;
            synchronized (list) {
                Activator.m_loggers.add(logger);
            }
        }
        return logger;
    }

    @Override
    public void clearMdc() {
        PaxLoggingLoggerProvider.getContext().clear();
    }

    @Override
    public Object putMdc(String key, Object value) {
        Object previous = this.getMdc(key);
        PaxLoggingLoggerProvider.getContext().put(key, value);
        return previous;
    }

    @Override
    public Object getMdc(String key) {
        return PaxLoggingLoggerProvider.getContext().get(key);
    }

    @Override
    public void removeMdc(String key) {
        PaxLoggingLoggerProvider.getContext().remove(key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        return PaxLoggingLoggerProvider.getContext().getCopyOfContextMap();
    }

    @Override
    public void clearNdc() {
    }

    @Override
    public String getNdc() {
        return null;
    }

    @Override
    public int getNdcDepth() {
        return 0;
    }

    @Override
    public String popNdc() {
        return null;
    }

    @Override
    public String peekNdc() {
        return null;
    }

    @Override
    public void pushNdc(String message) {
    }

    @Override
    public void setNdcMaxDepth(int maxDepth) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PaxContext getContext() {
        PaxLoggingManager manager = paxLogging;
        if (manager == null) return m_context != null ? m_context : m_defaultContext;
        Class<PaxLoggingLoggerProvider> clazz = PaxLoggingLoggerProvider.class;
        synchronized (PaxLoggingLoggerProvider.class) {
            PaxLoggingService service = manager.getPaxLoggingService();
            m_context = service != null ? service.getPaxContext() : null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_context != null ? m_context : m_defaultContext;
        }
    }

    static {
        m_defaultContext = new PaxContext();
    }
}

