/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Kafka IdempotentRepository")
public class KafkaIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String>,
CamelContextAware {
    private static final int DEFAULT_MAXIMUM_CACHE_SIZE = 1000;
    private static final int DEFAULT_POLL_DURATION_MS = 100;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicLong duplicateCount = new AtomicLong(0L);
    private String topic;
    private String bootstrapServers;
    private Properties producerConfig;
    private Properties consumerConfig;
    private int maxCacheSize = 1000;
    private int pollDurationMs = 100;
    private Map<String, Object> cache;
    private Consumer<String, String> consumer;
    private Producer<String, String> producer;
    private TopicPoller topicPoller;
    private CamelContext camelContext;
    private ExecutorService executorService;
    private CountDownLatch cacheReadyLatch;

    public KafkaIdempotentRepository() {
    }

    public KafkaIdempotentRepository(String topic, String bootstrapServers) {
        this(topic, bootstrapServers, 1000, 100);
    }

    public KafkaIdempotentRepository(String topic, String bootstrapServers, int maxCacheSize, int pollDurationMs) {
        this.topic = topic;
        this.bootstrapServers = bootstrapServers;
        this.maxCacheSize = maxCacheSize;
        this.pollDurationMs = pollDurationMs;
    }

    public KafkaIdempotentRepository(String topic, Properties consumerConfig, Properties producerConfig) {
        this(topic, consumerConfig, producerConfig, 1000, 100);
    }

    public KafkaIdempotentRepository(String topic, Properties consumerConfig, Properties producerConfig, int maxCacheSize, int pollDurationMs) {
        this.topic = topic;
        this.consumerConfig = consumerConfig;
        this.producerConfig = producerConfig;
        this.maxCacheSize = maxCacheSize;
        this.pollDurationMs = pollDurationMs;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public Properties getProducerConfig() {
        return this.producerConfig;
    }

    public void setProducerConfig(Properties producerConfig) {
        this.producerConfig = producerConfig;
    }

    public Properties getConsumerConfig() {
        return this.consumerConfig;
    }

    public void setConsumerConfig(Properties consumerConfig) {
        this.consumerConfig = consumerConfig;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public int getPollDurationMs() {
        return this.pollDurationMs;
    }

    public void setPollDurationMs(int pollDurationMs) {
        this.pollDurationMs = pollDurationMs;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        StringHelper.notEmpty((String)this.topic, (String)"topic");
        this.cache = LRUCacheFactory.newLRUCache((int)this.maxCacheSize);
        if (this.consumerConfig == null) {
            this.consumerConfig = new Properties();
            StringHelper.notEmpty((String)this.bootstrapServers, (String)"bootstrapServers");
            this.consumerConfig.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.producerConfig == null) {
            this.producerConfig = new Properties();
            StringHelper.notEmpty((String)this.bootstrapServers, (String)"bootstrapServers");
            this.producerConfig.put("bootstrap.servers", this.bootstrapServers);
        }
        ObjectHelper.notNull((Object)this.consumerConfig, (String)"consumerConfig");
        ObjectHelper.notNull((Object)this.producerConfig, (String)"producerConfig");
        String groupId = UUID.randomUUID().toString();
        this.log.debug("Creating consumer with {}[{}]", (Object)"group.id", (Object)groupId);
        this.consumerConfig.put("group.id", groupId);
        this.consumerConfig.put("enable.auto.commit", Boolean.TRUE.toString());
        this.consumerConfig.put("key.deserializer", StringDeserializer.class.getName());
        this.consumerConfig.put("value.deserializer", StringDeserializer.class.getName());
        this.consumer = new KafkaConsumer(this.consumerConfig);
        this.producerConfig.put("key.serializer", StringSerializer.class.getName());
        this.producerConfig.put("value.serializer", StringSerializer.class.getName());
        this.producerConfig.putIfAbsent("acks", "1");
        this.producerConfig.putIfAbsent("batch.size", "0");
        this.producer = new KafkaProducer(this.producerConfig);
        this.cacheReadyLatch = new CountDownLatch(1);
        this.topicPoller = new TopicPoller(this.consumer, this.cacheReadyLatch, this.pollDurationMs);
        this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "KafkaIdempotentRepository");
        this.executorService.submit(this.topicPoller);
        this.log.info("Warming up cache from topic {}", (Object)this.topic);
        try {
            if (this.cacheReadyLatch.await(30L, TimeUnit.SECONDS)) {
                this.log.info("Cache OK");
            } else {
                this.log.warn("Timeout waiting for cache warm-up from topic {}. Proceeding anyway. Duplicate records may not be detected.", (Object)this.topic);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while warming up cache. This exception is ignored.", (Object)e.getMessage());
        }
    }

    protected void doStop() {
        this.topicPoller.setRunning(false);
        try {
            if (this.topicPoller.getShutdownLatch().await(30L, TimeUnit.SECONDS)) {
                this.log.info("Cache from topic {} shutdown successfully", (Object)this.topic);
            } else {
                this.log.warn("Timeout waiting for cache to shutdown from topic {}. Proceeding anyway.", (Object)this.topic);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted waiting on shutting down cache due {}. This exception is ignored.", (Object)e.getMessage());
        }
        this.camelContext.getExecutorServiceManager().shutdown(this.executorService);
        IOHelper.close(this.consumer, (String)"consumer", (Logger)this.log);
        IOHelper.close(this.producer, (String)"producer", (Logger)this.log);
    }

    public boolean add(String key) {
        if (this.cache.containsKey(key)) {
            this.duplicateCount.incrementAndGet();
            return false;
        }
        this.cache.put(key, key);
        this.broadcastAction(key, CacheAction.add);
        return true;
    }

    private void broadcastAction(String key, CacheAction action) {
        try {
            this.log.debug("Broadcasting action:{} for key:{}", (Object)action, (Object)key);
            this.producer.send(new ProducerRecord(this.topic, (Object)key, (Object)action.toString())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        this.log.debug("Checking cache for key:{}", (Object)key);
        boolean containsKey = this.cache.containsKey(key);
        if (containsKey) {
            this.duplicateCount.incrementAndGet();
        }
        return containsKey;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cache.remove(key, key);
        this.broadcastAction(key, CacheAction.remove);
        return true;
    }

    public boolean confirm(String key) {
        return true;
    }

    public void clear() {
        this.broadcastAction(null, CacheAction.clear);
    }

    @ManagedOperation(description="Number of times duplicate messages have been detected")
    public long getDuplicateCount() {
        return this.duplicateCount.get();
    }

    @ManagedOperation(description="Number of times duplicate messages have been detected")
    public boolean isPollerRunning() {
        return this.topicPoller.isRunning();
    }

    private class TopicPoller
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Consumer<String, String> consumer;
        private final CountDownLatch cacheReadyLatch;
        private final int pollDurationMs;
        private final CountDownLatch shutdownLatch = new CountDownLatch(1);
        private final AtomicBoolean running = new AtomicBoolean(true);

        TopicPoller(Consumer<String, String> consumer, CountDownLatch cacheReadyLatch, int pollDurationMs) {
            this.consumer = consumer;
            this.cacheReadyLatch = cacheReadyLatch;
            this.pollDurationMs = pollDurationMs;
        }

        @Override
        public void run() {
            this.log.debug("Subscribing consumer to {}", (Object)KafkaIdempotentRepository.this.topic);
            this.consumer.subscribe(Collections.singleton(KafkaIdempotentRepository.this.topic));
            this.log.debug("Seeking to beginning");
            this.consumer.seekToBeginning((Collection)this.consumer.assignment());
            block2: while (this.running.get()) {
                this.log.trace("Polling");
                ConsumerRecords consumerRecords = this.consumer.poll((long)this.pollDurationMs);
                if (consumerRecords.isEmpty()) {
                    this.log.trace("0 messages fetched on poll");
                    if (this.cacheReadyLatch.getCount() > 0L) {
                        this.log.debug("Cache warmed up");
                        this.cacheReadyLatch.countDown();
                    }
                }
                for (ConsumerRecord consumerRecord : consumerRecords) {
                    CacheAction action;
                    try {
                        action = CacheAction.valueOf((String)consumerRecord.value());
                    }
                    catch (IllegalArgumentException iax) {
                        this.log.error("Unexpected action value:\"{}\" received on [topic:{}, partition:{}, offset:{}]. Shutting down.", new Object[]{consumerRecord.key(), consumerRecord.topic(), consumerRecord.partition(), consumerRecord.offset()});
                        this.setRunning(false);
                        continue block2;
                    }
                    String messageId = (String)consumerRecord.key();
                    if (action == CacheAction.add) {
                        this.log.debug("Adding to cache messageId:{}", (Object)messageId);
                        KafkaIdempotentRepository.this.cache.put(messageId, messageId);
                        continue;
                    }
                    if (action == CacheAction.remove) {
                        this.log.debug("Removing from cache messageId:{}", (Object)messageId);
                        KafkaIdempotentRepository.this.cache.remove(messageId);
                        continue;
                    }
                    if (action == CacheAction.clear) {
                        KafkaIdempotentRepository.this.cache.clear();
                        continue;
                    }
                    this.log.warn("No idea how to {} a record. Shutting down.", (Object)action);
                    this.setRunning(false);
                    continue block2;
                }
            }
            this.log.debug("TopicPoller finished - triggering shutdown latch");
            this.shutdownLatch.countDown();
        }

        CountDownLatch getShutdownLatch() {
            return this.shutdownLatch;
        }

        void setRunning(boolean running) {
            this.running.set(running);
        }

        boolean isRunning() {
            return this.running.get();
        }

        public String toString() {
            return "TopicPoller[" + KafkaIdempotentRepository.this.topic + "]";
        }
    }

    static enum CacheAction {
        add,
        remove,
        clear;

    }
}

