/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.Map;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluator;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluatorDispatcher;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.scripting.ScriptExecutor;

public class PastEventConditionEvaluator
implements ConditionEvaluator {
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private ScriptExecutor scriptExecutor;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        long count;
        Map parameters = condition.getParameterValues();
        Condition eventCondition = (Condition)parameters.get("eventCondition");
        if (parameters.containsKey("generatedPropertyKey")) {
            Number l;
            String key = (String)parameters.get("generatedPropertyKey");
            Profile profile = (Profile)item;
            Map pastEvents = (Map)profile.getSystemProperties().get("pastEvents");
            count = pastEvents != null ? ((l = (Number)pastEvents.get(key)) != null ? l.longValue() : 0L) : 0L;
        } else {
            if (eventCondition == null) {
                throw new IllegalArgumentException("No eventCondition");
            }
            ArrayList<Condition> l = new ArrayList<Condition>();
            Condition andCondition = new Condition();
            andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
            andCondition.setParameter("operator", (Object)"and");
            andCondition.setParameter("subConditions", l);
            l.add(ConditionContextHelper.getContextualCondition((Condition)eventCondition, context, (ScriptExecutor)this.scriptExecutor));
            Condition profileCondition = new Condition();
            profileCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            profileCondition.setParameter("propertyName", (Object)"profileId");
            profileCondition.setParameter("comparisonOperator", (Object)"equals");
            profileCondition.setParameter("propertyValue", (Object)item.getItemId());
            l.add(profileCondition);
            Integer numberOfDays = (Integer)condition.getParameter("numberOfDays");
            String fromDate = (String)condition.getParameter("fromDate");
            String toDate = (String)condition.getParameter("toDate");
            if (numberOfDays != null) {
                Condition numberOfDaysCondition = new Condition();
                numberOfDaysCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
                numberOfDaysCondition.setParameter("propertyName", (Object)"timeStamp");
                numberOfDaysCondition.setParameter("comparisonOperator", (Object)"greaterThan");
                numberOfDaysCondition.setParameter("propertyValueDateExpr", (Object)("now-" + numberOfDays + "d"));
                l.add(numberOfDaysCondition);
            }
            if (fromDate != null) {
                Condition startDateCondition = new Condition();
                startDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
                startDateCondition.setParameter("propertyName", (Object)"timeStamp");
                startDateCondition.setParameter("comparisonOperator", (Object)"greaterThanOrEqualTo");
                startDateCondition.setParameter("propertyValueDate", (Object)fromDate);
                l.add(startDateCondition);
            }
            if (toDate != null) {
                Condition endDateCondition = new Condition();
                endDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
                endDateCondition.setParameter("propertyName", (Object)"timeStamp");
                endDateCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
                endDateCondition.setParameter("propertyValueDate", (Object)toDate);
                l.add(endDateCondition);
            }
            count = this.persistenceService.queryCount(andCondition, "event");
        }
        Integer minimumEventCount = parameters.get("minimumEventCount") == null ? 0 : (Integer)parameters.get("minimumEventCount");
        Integer maximumEventCount = parameters.get("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)parameters.get("maximumEventCount");
        return count > 0L && count >= (long)minimumEventCount.intValue() && count <= (long)maximumEventCount.intValue();
    }
}

