/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.transport.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import shaded.org.apache.maven.wagon.StreamingWagon;
import shaded.org.apache.maven.wagon.Wagon;
import shaded.org.apache.maven.wagon.authentication.AuthenticationInfo;
import shaded.org.apache.maven.wagon.proxy.ProxyInfo;
import shaded.org.apache.maven.wagon.proxy.ProxyInfoProvider;
import shaded.org.apache.maven.wagon.repository.Repository;
import shaded.org.apache.maven.wagon.repository.RepositoryPermissions;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.repository.AuthenticationContext;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.spi.connector.transport.GetTask;
import shaded.org.eclipse.aether.spi.connector.transport.PeekTask;
import shaded.org.eclipse.aether.spi.connector.transport.PutTask;
import shaded.org.eclipse.aether.spi.connector.transport.TransportTask;
import shaded.org.eclipse.aether.spi.connector.transport.Transporter;
import shaded.org.eclipse.aether.transfer.NoTransporterException;
import shaded.org.eclipse.aether.transport.wagon.WagonCancelledException;
import shaded.org.eclipse.aether.transport.wagon.WagonConfigurator;
import shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import shaded.org.eclipse.aether.transport.wagon.WagonTransferListener;
import shaded.org.eclipse.aether.util.ConfigUtils;

final class WagonTransporter
implements Transporter {
    private static final String CONFIG_PROP_CONFIG = "aether.connector.wagon.config";
    private static final String CONFIG_PROP_FILE_MODE = "aether.connector.perms.fileMode";
    private static final String CONFIG_PROP_DIR_MODE = "aether.connector.perms.dirMode";
    private static final String CONFIG_PROP_GROUP = "aether.connector.perms.group";
    private static final Logger LOGGER = LoggerFactory.getLogger(WagonTransporter.class);
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final Properties headers;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final AtomicBoolean closed = new AtomicBoolean();

    WagonTransporter(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, RemoteRepository repository, RepositorySystemSession session) throws NoTransporterException {
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.repository = repository;
        this.session = session;
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonRepo.setPermissions(WagonTransporter.getPermissions(repository.getId(), session));
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        if (this.wagonHint == null || this.wagonHint.length() <= 0) {
            throw new NoTransporterException(repository);
        }
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            LOGGER.debug("No transport {}", (Object)e.getMessage(), (Object)e);
            throw new NoTransporterException(repository, e.getMessage(), e);
        }
        this.repoAuthContext = AuthenticationContext.forRepository(session, repository);
        this.proxyAuthContext = AuthenticationContext.forProxy(session, repository);
        this.wagonAuth = this.getAuthenticationInfo(repository, this.repoAuthContext);
        this.wagonProxy = this.getProxy(repository, this.proxyAuthContext);
        this.headers = new Properties();
        this.headers.put("User-Agent", ConfigUtils.getString(session, "Aether", "aether.connector.userAgent"));
        Map<?, ?> headers = ConfigUtils.getMap(session, null, "aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers");
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    private static RepositoryPermissions getPermissions(String repoId, RepositorySystemSession session) {
        String group;
        String dirMode;
        RepositoryPermissions result = null;
        RepositoryPermissions perms = new RepositoryPermissions();
        String suffix = '.' + repoId;
        String fileMode = ConfigUtils.getString(session, (String)null, CONFIG_PROP_FILE_MODE + suffix);
        if (fileMode != null) {
            perms.setFileMode(fileMode);
            result = perms;
        }
        if ((dirMode = ConfigUtils.getString(session, (String)null, CONFIG_PROP_DIR_MODE + suffix)) != null) {
            perms.setDirectoryMode(dirMode);
            result = perms;
        }
        if ((group = ConfigUtils.getString(session, (String)null, CONFIG_PROP_GROUP + suffix)) != null) {
            perms.setGroup(group);
            result = perms;
        }
        return result;
    }

    private AuthenticationInfo getAuthenticationInfo(RemoteRepository repository, final AuthenticationContext authContext) {
        AuthenticationInfo auth = null;
        if (authContext != null) {
            auth = new AuthenticationInfo(){

                @Override
                public String getUserName() {
                    return authContext.get("username");
                }

                @Override
                public String getPassword() {
                    return authContext.get("password");
                }

                @Override
                public String getPrivateKey() {
                    return authContext.get("privateKey.path");
                }

                @Override
                public String getPassphrase() {
                    return authContext.get("privateKey.passphrase");
                }
            };
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository, final AuthenticationContext authContext) {
        ProxyInfoProvider proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            final ProxyInfo prox = authContext != null ? new ProxyInfo(){

                @Override
                public String getUserName() {
                    return authContext.get("username");
                }

                @Override
                public String getPassword() {
                    return authContext.get("password");
                }

                @Override
                public String getNtlmDomain() {
                    return authContext.get("ntlm.domain");
                }

                @Override
                public String getNtlmHost() {
                    return authContext.get("ntlm.workstation");
                }
            } : new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            proxy = new ProxyInfoProvider(){

                @Override
                public ProxyInfo getProxyInfo(String protocol) {
                    return prox;
                }
            };
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws Exception {
        if (!this.headers.isEmpty()) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                setHttpHeaders.invoke((Object)wagon, this.headers);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                LOGGER.debug("Could not set user agent for wagon {}: {}", (Object)wagon.getClass().getName(), (Object)e.getMessage());
            }
        }
        int connectTimeout = ConfigUtils.getInteger(this.session, 10000, "aether.connector.connectTimeout");
        int requestTimeout = ConfigUtils.getInteger(this.session, 1800000, "aether.connector.requestTimeout");
        wagon.setTimeout(Math.max(Math.max(connectTimeout, requestTimeout), 0));
        wagon.setInteractive(ConfigUtils.getBoolean(this.session, false, "aether.interactive"));
        Object configuration = ConfigUtils.getObject(this.session, null, "aether.connector.wagon.config." + this.repository.getId());
        if (configuration != null && this.wagonConfigurator != null) {
            try {
                this.wagonConfigurator.configure(wagon, configuration);
            }
            catch (Exception e) {
                String msg = "Could not apply configuration for " + this.repository.getId() + " to wagon " + wagon.getClass().getName() + ":" + e.getMessage();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn(msg, (Throwable)e);
                }
                LOGGER.warn(msg);
            }
        }
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not disconnect wagon {}", (Object)wagon, (Object)e);
        }
    }

    private Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof ResourceDoesNotExistException) {
            return 1;
        }
        return 0;
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        this.execute(task, new PeekTaskRunner(task));
    }

    @Override
    public void get(GetTask task) throws Exception {
        this.execute(task, new GetTaskRunner(task));
    }

    @Override
    public void put(PutTask task) throws Exception {
        this.execute(task, new PutTaskRunner(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TransportTask task, TaskRunner runner) throws Exception {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
        try {
            WagonTransferListener listener = new WagonTransferListener(task.getListener());
            Wagon wagon = this.pollWagon();
            try {
                wagon.addTransferListener(listener);
                runner.run(wagon);
            }
            finally {
                wagon.removeTransferListener(listener);
                this.wagons.add(wagon);
            }
        }
        catch (Exception e) {
            throw WagonCancelledException.unwrap(e);
        }
    }

    private static File newTempFile() throws IOException {
        return File.createTempFile("wagon-" + UUID.randomUUID().toString().replace("-", ""), ".tmp");
    }

    private void delTempFile(File path) {
        if (path != null && !path.delete() && path.exists()) {
            LOGGER.debug("Could not delete temporary file {}", (Object)path);
            path.deleteOnExit();
        }
    }

    private static void copy(OutputStream os, InputStream is) throws IOException {
        byte[] buffer = new byte[32768];
        int read = is.read(buffer);
        while (read >= 0) {
            os.write(buffer, 0, read);
            read = is.read(buffer);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            AuthenticationContext.close(this.repoAuthContext);
            AuthenticationContext.close(this.proxyAuthContext);
            Wagon wagon = this.wagons.poll();
            while (wagon != null) {
                this.disconnectWagon(wagon);
                this.releaseWagon(wagon);
                wagon = this.wagons.poll();
            }
        }
    }

    private class PutTaskRunner
    implements TaskRunner {
        private final PutTask task;

        PutTaskRunner(PutTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Wagon wagon) throws Exception {
            String dst = this.task.getLocation().toString();
            File file = this.task.getDataFile();
            if (file == null && wagon instanceof StreamingWagon) {
                InputStream src = null;
                try {
                    src = this.task.newInputStream();
                    ((StreamingWagon)wagon).putFromStream(src, dst, this.task.getDataLength(), -1L);
                    src.close();
                    src = null;
                }
                finally {
                    try {
                        if (src != null) {
                            src.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            File src = file != null ? file : this.createTempFile();
            try {
                wagon.put(src, dst);
            }
            finally {
                if (file == null) {
                    WagonTransporter.this.delTempFile(src);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private File createTempFile() throws IOException {
            File tmp = WagonTransporter.newTempFile();
            OutputStream out = null;
            InputStream in = null;
            try {
                in = this.task.newInputStream();
                out = new FileOutputStream(tmp);
                WagonTransporter.copy(out, in);
                out.close();
                out = null;
                in.close();
                in = null;
            }
            catch (IOException e) {
                WagonTransporter.this.delTempFile(tmp);
                throw e;
            }
            finally {
                block30: {
                    block29: {
                        if (out == null) break block29;
                        out.close();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block30;
                    }
                    catch (IOException e) {}
                    break block30;
                    catch (IOException e) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e2) {}
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException e3) {}
                            throw throwable;
                        }
                    }
                }
            }
            return tmp;
        }
    }

    private class GetTaskRunner
    implements TaskRunner {
        private final GetTask task;

        GetTaskRunner(GetTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Wagon wagon) throws Exception {
            String src = this.task.getLocation().toString();
            File file = this.task.getDataFile();
            if (file == null && wagon instanceof StreamingWagon) {
                OutputStream dst = null;
                try {
                    dst = this.task.newOutputStream();
                    ((StreamingWagon)wagon).getToStream(src, dst);
                    dst.close();
                    dst = null;
                }
                finally {
                    try {
                        if (dst != null) {
                            dst.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            File dst = file != null ? file : WagonTransporter.newTempFile();
            try {
                wagon.get(src, dst);
                if (!dst.exists() && !dst.createNewFile()) {
                    throw new IOException(String.format("Failure creating file '%s'.", dst.getAbsolutePath()));
                }
                if (file == null) {
                    this.readTempFile(dst);
                }
            }
            finally {
                if (file == null) {
                    WagonTransporter.this.delTempFile(dst);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void readTempFile(File dst) throws IOException {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(dst);
                out = this.task.newOutputStream();
                WagonTransporter.copy(out, in);
                out.close();
                out = null;
                in.close();
                in = null;
            }
            finally {
                block28: {
                    block27: {
                        if (out == null) break block27;
                        out.close();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block28;
                    }
                    catch (IOException e) {}
                    break block28;
                    catch (IOException e) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e2) {}
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException e3) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    private static class PeekTaskRunner
    implements TaskRunner {
        private final PeekTask task;

        PeekTaskRunner(PeekTask task) {
            this.task = task;
        }

        @Override
        public void run(Wagon wagon) throws Exception {
            String src = this.task.getLocation().toString();
            if (!wagon.resourceExists(src)) {
                throw new ResourceDoesNotExistException("Could not find " + src + " in " + wagon.getRepository().getUrl());
            }
        }
    }

    private static interface TaskRunner {
        public void run(Wagon var1) throws Exception;
    }
}

