/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi.utils;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LoadPropertiesException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class BundleContextUtils {
    private BundleContextUtils() {
    }

    public static BundleContext getBundleContext(Class<?> clazz) {
        try {
            ClassLoader cl = clazz.getClassLoader();
            Method mth = null;
            for (Class<?> clClazz = cl.getClass(); clClazz != null; clClazz = clClazz.getSuperclass()) {
                try {
                    mth = clClazz.getDeclaredMethod("getBundle", new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (mth != null) {
                mth.setAccessible(true);
                return ((Bundle)mth.invoke((Object)cl, new Object[0])).getBundleContext();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Map<String, Properties> findComponents(BundleContext bundleContext, CamelContext camelContext) throws IOException, LoadPropertiesException {
        Bundle[] bundles;
        TreeMap<String, Properties> answer = new TreeMap<String, Properties>();
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            Enumeration iter = bundle.getResources("META-INF/services/org/apache/camel/component.properties");
            SortedMap map = CamelContextHelper.findComponents((CamelContext)camelContext, (Enumeration)iter);
            answer.putAll(map);
        }
        return answer;
    }
}

