/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.RuleListenerService;
import org.apache.unomi.shell.commands.TailCommandSupport;

@Command(scope="unomi", name="rule-tail", description="This will tail all the rules executed in the Apache Unomi Context Server")
@Service
public class RuleTail
extends TailCommandSupport {
    int[] columnSizes = new int[]{36, 36, 14, 36, 29, 15, 5};
    String[] columnHeaders = new String[]{"Rule ID", "Rule Name", "Event Type", "Session", "Profile", "Timestamp", "Scope"};

    @Override
    public int[] getColumnSizes() {
        return this.columnSizes;
    }

    @Override
    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public Object getListener() {
        return new TailRuleListener(this.session.getConsole());
    }

    class TailRuleListener
    implements RuleListenerService {
        PrintStream out;

        public TailRuleListener(PrintStream out) {
            this.out = out;
        }

        public void onEvaluate(Rule rule, Event event) {
        }

        public void onAlreadyRaised(RuleListenerService.AlreadyRaisedFor alreadyRaisedFor, Rule rule, Event event) {
        }

        public void onExecuteActions(Rule rule, Event event) {
            ArrayList<String> ruleExecutionInfo = new ArrayList<String>();
            ruleExecutionInfo.add(rule.getItemId());
            ruleExecutionInfo.add(rule.getMetadata().getName());
            ruleExecutionInfo.add(event.getEventType());
            ruleExecutionInfo.add(event.getSessionId());
            ruleExecutionInfo.add(event.getProfileId());
            ruleExecutionInfo.add(event.getTimeStamp().toString());
            ruleExecutionInfo.add(event.getScope());
            RuleTail.this.outputLine(this.out, ruleExecutionInfo);
        }
    }
}

