/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.compat;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.commands.CommandWithAction;
import org.apache.karaf.shell.compat.ArgumentCompleter;
import org.apache.karaf.shell.compat.OldArgumentCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CommandTracker
implements ServiceTrackerCustomizer<Object, Object> {
    SessionFactory sessionFactory;
    BundleContext context;
    ServiceTracker<?, ?> tracker;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void init() throws Exception {
        Filter filter = this.context.createFilter(String.format("(&(%s=*)(%s=*)(|(%s=%s)(%s=%s)))", "osgi.command.scope", "osgi.command.function", "objectClass", CommandWithAction.class.getName(), "objectClass", org.apache.felix.gogo.commands.CommandWithAction.class.getName()));
        this.tracker = new ServiceTracker(this.context, filter, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void destroy() {
        this.tracker.close();
    }

    public Object addingService(final ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof CommandWithAction) {
            final CommandWithAction oldCommand = (CommandWithAction)service;
            org.apache.karaf.shell.api.console.Command command = new org.apache.karaf.shell.api.console.Command(){

                public String getScope() {
                    return reference.getProperty("osgi.command.scope").toString();
                }

                public String getName() {
                    return reference.getProperty("osgi.command.function").toString();
                }

                public String getDescription() {
                    org.apache.karaf.shell.commands.Command cmd = oldCommand.getActionClass().getAnnotation(org.apache.karaf.shell.commands.Command.class);
                    if (cmd != null) {
                        return cmd.description();
                    }
                    try {
                        Method method = oldCommand.getActionClass().getMethod("description", new Class[0]);
                        method.setAccessible(true);
                        return (String)method.invoke((Object)oldCommand.createNewAction(), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        return this.getName();
                    }
                }

                public Completer getCompleter(boolean scoped) {
                    ArgumentCompleter completer = new ArgumentCompleter(oldCommand, this.getScope(), this.getName(), scoped);
                    return completer::complete;
                }

                public Parser getParser() {
                    return null;
                }

                public Object execute(Session session, List<Object> arguments) throws Exception {
                    CommandSession commandSession = (CommandSession)session.get(".commandSession");
                    return oldCommand.execute(commandSession, arguments);
                }
            };
            this.sessionFactory.getRegistry().register((Object)command);
            return command;
        }
        if (service instanceof org.apache.felix.gogo.commands.CommandWithAction) {
            final org.apache.felix.gogo.commands.CommandWithAction oldCommand = (org.apache.felix.gogo.commands.CommandWithAction)service;
            org.apache.karaf.shell.api.console.Command command = new org.apache.karaf.shell.api.console.Command(){

                public String getScope() {
                    return reference.getProperty("osgi.command.scope").toString();
                }

                public String getName() {
                    return reference.getProperty("osgi.command.function").toString();
                }

                public String getDescription() {
                    Command cmd = oldCommand.getActionClass().getAnnotation(Command.class);
                    if (cmd != null) {
                        return cmd.description();
                    }
                    try {
                        Method method = oldCommand.getActionClass().getMethod("description", new Class[0]);
                        method.setAccessible(true);
                        return (String)method.invoke((Object)oldCommand.createNewAction(), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        return this.getName();
                    }
                }

                public Completer getCompleter(boolean scoped) {
                    OldArgumentCompleter completer = new OldArgumentCompleter(oldCommand, this.getScope(), this.getName(), scoped);
                    return completer::complete;
                }

                public Parser getParser() {
                    return null;
                }

                public Object execute(Session session, List<Object> arguments) throws Exception {
                    CommandSession commandSession = (CommandSession)session.get(".commandSession");
                    return oldCommand.execute(commandSession, arguments);
                }
            };
            this.sessionFactory.getRegistry().register((Object)command);
            return command;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service instanceof org.apache.karaf.shell.api.console.Command) {
            this.sessionFactory.getRegistry().unregister(service);
        }
        if (service instanceof List) {
            List commands = (List)service;
            for (org.apache.karaf.shell.api.console.Command command : commands) {
                this.sessionFactory.getRegistry().unregister((Object)command);
            }
        }
        this.context.ungetService(reference);
    }
}

