/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.opt.util.CacheMap;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    private static final int PRINCIPALS_CACHE_SIZE = 10;
    private static final int ACC_CACHE_SIZE = 10;
    private CacheMap principalsCache;
    private CacheMap accCache;

    public synchronized AccessControlContext delegatedContext(AccessControlContext authenticatedACC, Subject delegatedSubject) throws SecurityException {
        AccessControlContext delegatedACC;
        Principal[] delegatedPrincipals;
        if (this.principalsCache == null || this.accCache == null) {
            this.principalsCache = new CacheMap(10);
            this.accCache = new CacheMap(10);
        }
        if ((delegatedPrincipals = (Principal[])this.principalsCache.get(delegatedSubject)) == null) {
            delegatedPrincipals = delegatedSubject.getPrincipals().toArray(new Principal[0]);
            this.principalsCache.put(delegatedSubject, delegatedPrincipals);
        }
        if ((delegatedACC = (AccessControlContext)this.accCache.get(delegatedSubject)) == null) {
            JMXSubjectDomainCombiner sdc = new JMXSubjectDomainCombiner(delegatedSubject);
            delegatedACC = new AccessControlContext(AccessController.getContext(), sdc);
            this.accCache.put(delegatedSubject, delegatedACC);
        }
        final Principal[] dp = delegatedPrincipals;
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < dp.length; ++i) {
                    String pname = dp[i].getClass().getName() + "." + dp[i].getName();
                    SubjectDelegationPermission sdp = new SubjectDelegationPermission(pname);
                    AccessController.checkPermission(sdp);
                }
                return null;
            }
        };
        AccessController.doPrivileged(action, authenticatedACC);
        return delegatedACC;
    }
}

