/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.transaction.BundleWideTxData;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.MatchedTxData;
import org.apache.aries.transaction.annotations.TransactionPropagationType;

public class BundleWideTxDataUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionPropagationType getAttribute(String compId, String method, List<BundleWideTxData> bundleData) {
        BundleWideTxData txData = null;
        if (bundleData.size() != 1) return BundleWideTxDataUtil.getTransactionAttribute(bundleData, compId, method);
        txData = bundleData.get(0);
        List<Pattern> beans = txData.getBean();
        List<Pattern> mtds = txData.getMethod();
        TransactionPropagationType value = txData.getValue();
        if (!beans.isEmpty() && !mtds.isEmpty()) {
            for (Pattern bean : beans) {
                if (!bean.matcher(compId).matches()) continue;
                for (Pattern mtd : mtds) {
                    if (!mtd.matcher(method).matches()) continue;
                    return value;
                }
            }
            return null;
        } else if (!beans.isEmpty()) {
            for (Pattern bean : beans) {
                if (!bean.matcher(compId).matches()) continue;
                return value;
            }
            return null;
        } else {
            if (mtds.isEmpty()) return value;
            for (Pattern mtd : mtds) {
                if (!mtd.matcher(method).matches()) continue;
                return value;
            }
        }
        return null;
    }

    private static TransactionPropagationType getTransactionAttribute(List<BundleWideTxData> bundleData, String compId, String method) {
        TransactionPropagationType value;
        List<Pattern> beans;
        List<Pattern> mtds;
        ArrayList<BundleWideTxData> bundleDataBothMethodAndBean = new ArrayList<BundleWideTxData>();
        ArrayList<BundleWideTxData> bundleDataOnlyBean = new ArrayList<BundleWideTxData>();
        ArrayList<BundleWideTxData> bundleDataOnlyMethod = new ArrayList<BundleWideTxData>();
        ArrayList<BundleWideTxData> bundleDataNoRestriction = new ArrayList<BundleWideTxData>();
        for (BundleWideTxData txData : bundleData) {
            List<Pattern> beans2 = txData.getBean();
            mtds = txData.getMethod();
            if (!beans2.isEmpty() && !mtds.isEmpty()) {
                bundleDataBothMethodAndBean.add(txData);
                continue;
            }
            if (!beans2.isEmpty()) {
                bundleDataOnlyBean.add(txData);
                continue;
            }
            if (!mtds.isEmpty()) {
                bundleDataOnlyMethod.add(txData);
                continue;
            }
            bundleDataNoRestriction.add(txData);
        }
        ArrayList<MatchedTxData> matchedTxData = new ArrayList<MatchedTxData>();
        for (BundleWideTxData txData : bundleDataBothMethodAndBean) {
            beans = txData.getBean();
            List<Pattern> mtds2 = txData.getMethod();
            TransactionPropagationType value2 = txData.getValue();
            for (Pattern bean : beans) {
                if (!bean.matcher(compId).matches()) continue;
                for (Pattern mtd : mtds2) {
                    if (!mtd.matcher(method).matches()) continue;
                    matchedTxData.add(new MatchedTxData(value2, mtd, bean));
                }
            }
        }
        if (!matchedTxData.isEmpty()) {
            return BundleWideTxDataUtil.findBestMatch(matchedTxData);
        }
        for (BundleWideTxData txData : bundleDataOnlyBean) {
            beans = txData.getBean();
            value = txData.getValue();
            for (Pattern bean : beans) {
                if (!bean.matcher(compId).matches()) continue;
                matchedTxData.add(new MatchedTxData(value, null, bean));
            }
        }
        if (!matchedTxData.isEmpty()) {
            return BundleWideTxDataUtil.findBestMatchBeanOnly(matchedTxData);
        }
        for (BundleWideTxData txData : bundleDataOnlyMethod) {
            mtds = txData.getMethod();
            value = txData.getValue();
            for (Pattern mtd : mtds) {
                if (!mtd.matcher(method).matches()) continue;
                matchedTxData.add(new MatchedTxData(value, mtd, null));
            }
        }
        if (!matchedTxData.isEmpty()) {
            return BundleWideTxDataUtil.findBestMatchMethodOnly(matchedTxData);
        }
        Iterator i$ = bundleDataNoRestriction.iterator();
        if (i$.hasNext()) {
            BundleWideTxData txData;
            txData = (BundleWideTxData)i$.next();
            return txData.getValue();
        }
        if (bundleDataNoRestriction.size() == 0) {
            return null;
        }
        if (bundleDataNoRestriction.size() == 1) {
            return ((BundleWideTxData)bundleDataNoRestriction.get(0)).getValue();
        }
        throw new IllegalStateException(Constants.MESSAGES.getMessage("bundle.wide.tx", new Object[]{bundleDataNoRestriction}));
    }

    private static TransactionPropagationType findBestMatch(List<MatchedTxData> matchedTxData) {
        if (matchedTxData.size() == 1) {
            return matchedTxData.get(0).getValue();
        }
        List<MatchedTxData> matchesBean1 = BundleWideTxDataUtil.selectPatternsWithFewestWildcards(matchedTxData, true);
        if (matchesBean1.size() == 1) {
            return matchesBean1.get(0).getValue();
        }
        List<MatchedTxData> matchesBean2 = BundleWideTxDataUtil.selectLongestPatterns(matchesBean1, true);
        if (matchesBean2.size() == 1) {
            return matchesBean2.get(0).getValue();
        }
        List<MatchedTxData> matchesMethod1 = BundleWideTxDataUtil.selectPatternsWithFewestWildcards(matchesBean2, false);
        if (matchesMethod1.size() == 1) {
            return matchesMethod1.get(0).getValue();
        }
        List<MatchedTxData> matchesMethod2 = BundleWideTxDataUtil.selectLongestPatterns(matchesMethod1, false);
        if (matchesMethod2.size() == 1) {
            return matchesMethod2.get(0).getValue();
        }
        throw new IllegalStateException(Constants.MESSAGES.getMessage("unable.to.apply.patterns", new Object[]{matchedTxData}));
    }

    private static TransactionPropagationType findBestMatchBeanOnly(List<MatchedTxData> matchedTxData) {
        if (matchedTxData.size() == 1) {
            return matchedTxData.get(0).getValue();
        }
        List<MatchedTxData> matchesBean1 = BundleWideTxDataUtil.selectPatternsWithFewestWildcards(matchedTxData, true);
        if (matchesBean1.size() == 1) {
            return matchesBean1.get(0).getValue();
        }
        List<MatchedTxData> matchesBean2 = BundleWideTxDataUtil.selectLongestPatterns(matchesBean1, true);
        if (matchesBean2.size() == 1) {
            return matchesBean2.get(0).getValue();
        }
        throw new IllegalStateException(Constants.MESSAGES.getMessage("unable.to.apply.patterns", new Object[]{matchedTxData}));
    }

    private static TransactionPropagationType findBestMatchMethodOnly(List<MatchedTxData> matchedTxData) {
        if (matchedTxData.size() == 1) {
            return matchedTxData.get(0).getValue();
        }
        List<MatchedTxData> matchesMethod1 = BundleWideTxDataUtil.selectPatternsWithFewestWildcards(matchedTxData, false);
        if (matchesMethod1.size() == 1) {
            return matchesMethod1.get(0).getValue();
        }
        List<MatchedTxData> matchesMethod2 = BundleWideTxDataUtil.selectLongestPatterns(matchesMethod1, false);
        if (matchesMethod2.size() == 1) {
            return matchesMethod2.get(0).getValue();
        }
        throw new IllegalStateException(Constants.MESSAGES.getMessage("unable.to.apply.patterns", new Object[]{matchedTxData}));
    }

    private static List<MatchedTxData> selectPatternsWithFewestWildcards(List<MatchedTxData> matchedTxData, boolean isBean) {
        ArrayList<MatchedTxData> remainingMatches = new ArrayList<MatchedTxData>();
        int minWildcards = Integer.MAX_VALUE;
        for (MatchedTxData mData : matchedTxData) {
            Pattern p = isBean ? mData.getBean() : mData.getMethod();
            String pattern = p.pattern();
            Matcher m = Constants.WILDCARD.matcher(pattern);
            int count = 0;
            while (m.find()) {
                ++count;
            }
            if (count < minWildcards) {
                remainingMatches.clear();
                remainingMatches.add(mData);
                minWildcards = count;
                continue;
            }
            if (count != minWildcards) continue;
            remainingMatches.add(mData);
        }
        return remainingMatches;
    }

    private static List<MatchedTxData> selectLongestPatterns(List<MatchedTxData> matchedTxData, boolean isBean) {
        ArrayList<MatchedTxData> remainingMatches = new ArrayList<MatchedTxData>();
        int longestLength = 0;
        for (MatchedTxData mData : matchedTxData) {
            Pattern p = isBean ? mData.getBean() : mData.getMethod();
            String pattern = p.pattern();
            int length = pattern.length();
            if (length > longestLength) {
                remainingMatches.clear();
                remainingMatches.add(mData);
                longestLength = length;
                continue;
            }
            if (length != longestLength) continue;
            remainingMatches.add(mData);
        }
        return remainingMatches;
    }
}

