/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.usage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.action.admin.cluster.node.usage.NodeUsage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.rest.BaseRestHandler;

public class UsageService {
    private final List<BaseRestHandler> handlers = new ArrayList<BaseRestHandler>();
    private final long sinceTime = System.currentTimeMillis();

    public void addRestHandler(BaseRestHandler handler) {
        this.handlers.add(handler);
    }

    public NodeUsage getUsageStats(DiscoveryNode localNode, boolean restActions) {
        HashMap<String, Long> restUsageMap;
        if (restActions) {
            restUsageMap = new HashMap<String, Long>();
            this.handlers.forEach(handler -> {
                long usageCount = handler.getUsageCount();
                if (usageCount > 0L) {
                    restUsageMap.put(handler.getName(), usageCount);
                }
            });
        } else {
            restUsageMap = null;
        }
        return new NodeUsage(localNode, System.currentTimeMillis(), this.sinceTime, restUsageMap);
    }
}

