/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestRequest;

public class StoredFieldsContext
implements Writeable {
    public static final String _NONE_ = "_none_";
    private final List<String> fieldNames;
    private boolean fetchFields;

    private StoredFieldsContext(boolean fetchFields) {
        this.fetchFields = fetchFields;
        this.fieldNames = null;
    }

    private StoredFieldsContext(List<String> fieldNames) {
        Objects.requireNonNull(fieldNames, "fieldNames must not be null");
        this.fetchFields = true;
        this.fieldNames = new ArrayList<String>(fieldNames);
    }

    public StoredFieldsContext(StoredFieldsContext other) {
        this.fetchFields = other.fetchFields();
        this.fieldNames = other.fieldNames() != null ? new ArrayList<String>(other.fieldNames()) : null;
    }

    public StoredFieldsContext(StreamInput in) throws IOException {
        this.fetchFields = in.readBoolean();
        this.fieldNames = this.fetchFields ? new ArrayList<String>((List)in.readGenericValue()) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fetchFields);
        if (this.fetchFields) {
            out.writeGenericValue(this.fieldNames);
        }
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public StoredFieldsContext addFieldNames(List<String> fieldNames) {
        if (!this.fetchFields || fieldNames.contains(_NONE_)) {
            throw new IllegalArgumentException("cannot combine _none_ with other fields");
        }
        this.fieldNames.addAll(fieldNames);
        return this;
    }

    public StoredFieldsContext addFieldName(String field) {
        if (!this.fetchFields || _NONE_.equals(field)) {
            throw new IllegalArgumentException("cannot combine _none_ with other fields");
        }
        this.fieldNames.add(field);
        return this;
    }

    public boolean fetchFields() {
        return this.fetchFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredFieldsContext that = (StoredFieldsContext)o;
        if (this.fetchFields != that.fetchFields) {
            return false;
        }
        return this.fieldNames != null ? this.fieldNames.equals(that.fieldNames) : that.fieldNames == null;
    }

    public int hashCode() {
        int result = this.fieldNames != null ? this.fieldNames.hashCode() : 0;
        result = 31 * result + (this.fetchFields ? 1 : 0);
        return result;
    }

    public void toXContent(String preferredName, XContentBuilder builder) throws IOException {
        if (!this.fetchFields) {
            builder.field(preferredName, _NONE_);
        }
        if (this.fieldNames != null) {
            if (this.fieldNames.size() == 1) {
                builder.field(preferredName, this.fieldNames.get(0));
            } else {
                builder.startArray(preferredName);
                for (String fieldName : this.fieldNames) {
                    builder.value(fieldName);
                }
                builder.endArray();
            }
        }
    }

    public static StoredFieldsContext fromList(List<String> fieldNames) {
        if (fieldNames.size() == 1 && _NONE_.equals(fieldNames.get(0))) {
            return new StoredFieldsContext(false);
        }
        if (fieldNames.contains(_NONE_)) {
            throw new IllegalArgumentException("cannot combine _none_ with other fields");
        }
        return new StoredFieldsContext(fieldNames);
    }

    public static StoredFieldsContext fromXContent(String fieldName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return StoredFieldsContext.fromList(Collections.singletonList(parser.text()));
        }
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<String> list = new ArrayList<String>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                list.add(parser.text());
            }
            return StoredFieldsContext.fromList(list);
        }
        throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.VALUE_STRING) + "] or [" + (Object)((Object)XContentParser.Token.START_ARRAY) + "] in [" + fieldName + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
    }

    public static StoredFieldsContext fromRestRequest(String name, RestRequest request) {
        String sField = request.param(name);
        if (sField != null) {
            String[] sFields = Strings.splitStringByCommaToArray(sField);
            return StoredFieldsContext.fromList(Arrays.asList(sFields));
        }
        return null;
    }
}

